/*
 * Decompiled with CFR 0.152.
 */
package com.securegencl;

import SecuGen.FDxSDKPro.jni.JSGFPLib;
import SecuGen.FDxSDKPro.jni.SGDeviceInfoParam;
import SecuGen.FDxSDKPro.jni.SGFingerInfo;
import com.securegencl.EmpData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SecureGenCli {
    public static void main(String[] args) throws ParseException, IOException, ClassNotFoundException {
        EmpData empdata;
        byte[] kbBuffer = new byte[100];
        byte[] kbWhichFinger = new byte[100];
        boolean fingerLength = false;
        ArrayList empList = new ArrayList();
        Options options = new Options();
        options.addOption("enroll", true, "Enroll  <Employe ID> as argument ");
        options.addOption("name", true, "Enter Employe Name");
        options.addOption("verify", false, "Verify finger print ");
        options.addOption("delete", true, "Delete finger print of <Employe ID> as arument");
        options.addOption("list", false, "Show list of eployers");
        options.addOption("h", "hostaddress", false, "Set Host address Biometric connected to");
        options.addOption("L", "Listen server", true, " <Port> as argument Work as server connected to BIO device ");
        options.addOption("t", "timeout", true, "Set maximum time to read from Biometric device");
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(options, args);
        if (line.hasOption("enroll")) {
            System.out.println(line.getOptionValue("enroll"));
        }
        Object fout = null;
        Object fp = null;
        for (int i = 0; i < kbWhichFinger.length; ++i) {
            kbWhichFinger[i] = 0;
        }
        File empfingers = new File("fingers.dat");
        if (empfingers.exists() && empfingers.length() > 0L) {
            FileInputStream fis = new FileInputStream(empfingers);
            ObjectInputStream ois = new ObjectInputStream(fis);
            empList = (ArrayList)ois.readObject();
            ois.close();
        }
        if (line.hasOption("enroll") && line.getOptionValue("enroll") != "") {
            if (SecureGenCli.existEmpData(line.getOptionValue("enroll"), empList)) {
                System.out.println("Elplyee already exist");
            } else {
                empdata = new EmpData();
                empdata.setEmp_id(line.getOptionValue("enroll"));
                empdata.setEmp_name("");
                empdata.setSG400minutiaeBuffer(SecureGenCli.getFingerPrint());
                empList.add(empdata);
            }
        }
        if (line.hasOption("delete") && line.getOptionValue("delete") != "") {
            SecureGenCli.deleteEmpData(line.getOptionValue("delete"), empList);
        }
        if (line.hasOption("list")) {
            SecureGenCli.listEmpData(empList);
        }
        if (line.hasOption("verify")) {
            empdata = new EmpData();
            empdata.setEmp_name("");
            empdata.setSG400minutiaeBuffer(SecureGenCli.getFingerPrint());
            empdata.setEmp_id(SecureGenCli.findEmpByFinger(empdata, empList));
            System.out.println("User id is :" + empdata.getEmp_id());
        }
        FileOutputStream fos = new FileOutputStream(empfingers);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(empList);
        oos.close();
    }

    private static String findEmpByFinger(EmpData emptorec, List<EmpData> empList) {
        for (EmpData empData : empList) {
            JSGFPLib sgfplib = SecureGenCli.initBioLib();
            if (SecureGenCli.testMinutiaeMatch(sgfplib, emptorec.getSG400minutiaeBuffer(), empData.getSG400minutiaeBuffer())) {
                System.out.println("emp : " + empData.getEmp_id());
                sgfplib = null;
                return empData.getEmp_id();
            }
            sgfplib.Close();
            sgfplib = null;
        }
        return "";
    }

    private static byte[] getFingerPrint() {
        int[] quality = new int[1];
        int[] maxSize = new int[1];
        int[] size = new int[1];
        JSGFPLib sgfplib = SecureGenCli.initBioLib();
        SGDeviceInfoParam deviceInfo = SecureGenCli.GetDeviceInfo(sgfplib);
        byte[] imageBuffer1 = new byte[deviceInfo.imageHeight * deviceInfo.imageWidth];
        imageBuffer1 = SecureGenCli.getImage(sgfplib, deviceInfo);
        quality = SecureGenCli.getImgageQuality(sgfplib, deviceInfo, imageBuffer1);
        int[] maxTemplateSize = SecureGenCli.getMaxTemplateSize(sgfplib);
        byte[] SG400minutiaeBuffer1 = new byte[maxTemplateSize[0]];
        try {
            SG400minutiaeBuffer1 = SecureGenCli.createTemplate(sgfplib, SecureGenCli.getFingetInfo(), imageBuffer1, maxTemplateSize);
        }
        catch (IOException ex) {
            Logger.getLogger(SecureGenCli.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("Call Close()");
        sgfplib.Close();
        sgfplib = null;
        imageBuffer1 = null;
        return SG400minutiaeBuffer1;
    }

    private static JSGFPLib initBioLib() {
        byte[] kbWhichFinger = new byte[100];
        boolean fingerLength = false;
        for (int i = 0; i < kbWhichFinger.length; ++i) {
            kbWhichFinger[i] = 0;
        }
        JSGFPLib sgfplib = new JSGFPLib();
        if (sgfplib == null || sgfplib.jniLoadStatus == 201L) {
            System.out.println("An error occurred while loading JSGFPLIB.DLL JNI Wrapper");
        }
        long err = sgfplib.Init(255L);
        err = sgfplib.GetLastError();
        int[] extractorVersion = new int[1];
        int[] matcherVersion = new int[1];
        err = sgfplib.GetMinexVersion(extractorVersion, matcherVersion);
        err = sgfplib.OpenDevice(957L);
        err = sgfplib.GetLastError();
        return sgfplib;
    }

    private static byte[] getImage(JSGFPLib sgfplib, SGDeviceInfoParam deviceInfo) {
        int[] quality = new int[1];
        int[] maxSize = new int[1];
        int[] size = new int[1];
        SGFingerInfo fingerInfo = new SGFingerInfo();
        fingerInfo.FingerNumber = 7;
        fingerInfo.ImageQuality = quality[0];
        fingerInfo.ImpressionType = 0;
        fingerInfo.ViewNumber = 1;
        byte[] imageBuffer1 = new byte[deviceInfo.imageHeight * deviceInfo.imageWidth];
        long err = sgfplib.SetLedOn(true);
        System.out.println("SetLedOn returned : [" + err + "]");
        int image_quality = 50;
        int timeout = 10000;
        err = sgfplib.GetImageEx(imageBuffer1, (long)timeout, 0L, (long)image_quality);
        System.out.println("GetImageEx returned : [" + err + "]");
        if (err == 0L) {
            err = sgfplib.GetImageQuality((long)deviceInfo.imageWidth, (long)deviceInfo.imageHeight, imageBuffer1, quality);
            System.out.println("GetImageQuality returned : [" + err + "]");
            System.out.println("Image Quality is : [" + quality[0] + "]");
            System.out.println("SetLedOn returned : [" + err + "]");
        }
        return imageBuffer1;
    }

    private static boolean existEmpData(String empID, List<EmpData> empList) {
        for (EmpData empData : empList) {
            if (!empData.getEmp_id().equals(empID)) continue;
            return true;
        }
        return false;
    }

    private static void listEmpData(List<EmpData> empList) {
        for (EmpData empData : empList) {
            System.out.println("employee :" + empData.getEmp_id() + "\n");
        }
    }

    private static List<EmpData> deleteEmpData(String empID, List<EmpData> empList) {
        for (EmpData empData : empList) {
            if (!empData.getEmp_id().equals(empID)) continue;
            empList.remove(empData);
        }
        return empList;
    }

    private static boolean testMinutiaeMatch(JSGFPLib sgfplib, byte[] SG400minutiaeBuffer1, byte[] SG400minutiaeBuffer2) {
        boolean[] matched = new boolean[1];
        int[] score = new int[1];
        matched[0] = false;
        score[0] = 0;
        long err = sgfplib.SetTemplateFormat((short)512);
        err = sgfplib.MatchTemplate(SG400minutiaeBuffer1, SG400minutiaeBuffer2, 5L, matched);
        err = sgfplib.GetMatchingScore(SG400minutiaeBuffer1, SG400minutiaeBuffer2, score);
        return matched[0];
    }

    private static SGDeviceInfoParam GetDeviceInfo(JSGFPLib sgfplib) {
        System.out.println("Call GetDeviceInfo()");
        SGDeviceInfoParam deviceInfo = new SGDeviceInfoParam();
        long err = sgfplib.GetDeviceInfo(deviceInfo);
        return deviceInfo;
    }

    private static SGFingerInfo getFingetInfo() {
        SGFingerInfo fingerInfo = new SGFingerInfo();
        int[] quality = new int[1];
        fingerInfo.FingerNumber = 7;
        fingerInfo.ImageQuality = quality[0];
        fingerInfo.ImpressionType = 0;
        fingerInfo.ViewNumber = 1;
        return fingerInfo;
    }

    private static int[] getMaxTemplateSize(JSGFPLib sgfplib) {
        int[] maxSize = new int[1];
        String finger = new String("finger");
        System.out.println("Call SetTemplateFormat(SG400)");
        long err = sgfplib.SetTemplateFormat((short)512);
        System.out.println("SetTemplateFormat returned : [" + err + "]");
        System.out.println("Call GetMaxTemplateSize()");
        err = sgfplib.GetMaxTemplateSize(maxSize);
        System.out.println("GetMaxTemplateSize returned : [" + err + "]");
        System.out.println("Max SG400 Template Size is : [" + maxSize[0] + "]");
        return maxSize;
    }

    private static byte[] createTemplate(JSGFPLib sgfplib, SGFingerInfo fingerInfo, byte[] imageBuffer1, int[] maxSize) throws IOException {
        FileOutputStream fout = null;
        PrintStream fp = null;
        int[] size = new int[1];
        byte[] SG400minutiaeBuffer1 = new byte[maxSize[0]];
        long err = sgfplib.CreateTemplate(fingerInfo, imageBuffer1, SG400minutiaeBuffer1);
        err = sgfplib.GetTemplateSize(SG400minutiaeBuffer1, size);
        if (err == 0L) {
            try {
                fout = new FileOutputStream(fingerInfo.FingerNumber + ".sg400");
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(SecureGenCli.class.getName()).log(Level.SEVERE, null, ex);
            }
            fp = new PrintStream(fout);
            fp.write(SG400minutiaeBuffer1, 0, size[0]);
            fp.close();
            fout.close();
            fp = null;
            fout = null;
        }
        return SG400minutiaeBuffer1;
    }

    private static int[] getImgageQuality(JSGFPLib sgfplib, SGDeviceInfoParam deviceInfo, byte[] imageBuffer1) {
        int[] quality = new int[1];
        long err = sgfplib.GetImageQuality((long)deviceInfo.imageWidth, (long)deviceInfo.imageHeight, imageBuffer1, quality);
        return quality;
    }
}

