<!DOCTYPE html>
<html>
 <head>
   <title>Geocoding service</title>
   <meta name="viewport" content="initial-scale=1.0, user-scalable=no">
   <meta charset="utf-8">

   <style>
     /* Always set the map height explicitly to define the size of the div
      * element that contains the map. */
     #map {
       height: 100%;
     }

     /* Optional: Makes the sample page fill the window. */
     html, body {
       height: 100%;
       margin: 0;
       padding: 0;
     }

     #floating-panel {
       position: absolute;
       top: 10px;
       left: 25%;
       z-index: 5;
       background-color: #fff;
       padding: 5px;
       border: 1px solid #999;
       text-align: center;
       font-family: 'Arial','sans-serif';
       line-height: 30px;
       padding-left: 5px;
     }
    </style>

  <script>

  var rad = function(x) {  
   return x * Math.PI / 180;
  };

  var getDistance = function(p1, p2) {
   var R = 6371302 ; // Earth s mean radius in meter
   var dLat = rad(p2.lat() - p1.lat());
   var dLong = rad(p2.lng() - p1.lng());

   var a = Math.sin(dLat / 2) * Math.sin(dLat / 2) +
    Math.cos(rad(p1.lat())) * Math.cos(rad(p2.lat())) *
    Math.sin(dLong / 2) * Math.sin(dLong / 2);

   var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
   var d = R * c;
   return d; // returns the distance in meter
  }

  </script>
  </head>

  <body>
    <div id="floating-panel">
      <input id="address" type="textbox" value="">
      <input id="submit" type="button" value="Search">
    </div>

    <div id="map"></div>

    <script>

    function initMap()
      {
        var map = new google.maps.Map(document.getElementById('map'), {
        zoom: 8,
        center: {lat: 32.08 , lng: 34.78 }
        });
        var geocoder = new google.maps.Geocoder();

        document.getElementById('submit').addEventListener('click', function() {
          geocodeAddress(geocoder, map);
        });
      }

      function geocodeAddress(geocoder, resultsMap)
      {
        var address = document.getElementById('address').value;
        //alert("address="+address)

        geocoder.geocode({'address': address}, function(results, status) {
          //alert("status="+status)
          if (status === 'OK') {
            var loc=results[0].geometry.location
            var pid=results[0].place_id
            var bnd=results[0].geometry.bounds
            var adr=results[0].formatted_address
            var short=results[0].address_components[0].short_name
            var long=results[0].address_components[0].long_name
            var plc=results[0].address_components[0].postcode_localities
            var tps=results[0].address_components[0].types[0]

            alert("loc="+loc+"  place id="+pid+"  <br>bounds="+bnd +" <br> adr="+adr+"  <br>short="+short+"  <br>long="+long+"  <br>plc="+plc+"  <br>tps="+tps )

            resultsMap.setCenter(loc);

            var marker = new google.maps.Marker({
              map: resultsMap,
              position: loc // results[0].geometry.location
            });

            var coord1=new google.maps.LatLng(32.08, 34.7737)
            var coord2=new google.maps.LatLng(loc.lat() , loc.lng() )

            var distance = getDistance(coord1,coord2)

            alert("distance="+distance )

          }
          else {
            alert('Geocode was not successful for the following reason: ' + status);
               }
        });
       }
    </script>

    <script async defer
      src="https://maps.googleapis.com/maps/api/js?key=AIzaSyApyJhT6NQb5Iv-llf5ACH1-LjXmzpov_0&callback=initMap">
    </script>

    </body>
   </html>









