<!-- ----------------- w1dogtm --------------------- -->
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="java.io.*" %>
<%
    String gtmDist = System.getenv("gtm_dist");
    String gtmRoutines = "/home/gtmuser/app/mumps";

    String command = "mumps -run W1DO" ;
    out.println("command=" + command);

    long startTime = System.currentTimeMillis();
    long timeout = 15000;

    try {
        Process proc = Runtime.getRuntime().exec(command);

        BufferedWriter writer = new BufferedWriter(
            new OutputStreamWriter(proc.getOutputStream(), "UTF-8")
        );

        BufferedReader reqReader =request.getReader();

        String line;

       while ((line = reqReader.readLine()) != null) {
            writer.write(line);
            writer.newLine();
       }
       writer.flush();
       writer.close();

       BufferedReader procReader = new BufferedReader(
            new InputStreamReader(proc.getInputStream(), "UTF-8")
       );

        while ((line = procReader.readLine()) != null) {
            if (System.currentTimeMillis() - startTime > timeout) {
              out.println("<br><b>Timeout: 15 sec</b><br>");
              proc.destroy();
              break;
            }
            out.println(line + "<br>");
            out.flush(); 
        }
        procReader.close();
        out.println("Read done<br>");

        BufferedReader errReader = new BufferedReader(
            new InputStreamReader(proc.getErrorStream(), "UTF-8")
        );
        while ((line = errReader.readLine()) != null) {
            System.err.println(line);
        }
        errReader.close();

    } catch (Exception e) {
        out.println("Error: " + e.getMessage());
    }
%>
