<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>........... ....</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5e6cc;
            margin: 0;
            padding: 20px;
        }
        .menu {
            width: 300px;
            background: white;
            border-radius: 10px;
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .menu-item {
            padding: 12px;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid #ddd;
        }
        .menu-item:hover {
            background: #f0d9b5;
        }
        .submenu {
            display: none;
            background: #fff6e5;
            padding-left: 20px;
        }
        .submenu .menu-item {
            border-bottom: none;
            padding: 10px;
        }
        .folder {
            font-size: 16px;
        }
    </style>
</head>
<body>
    <div class="menu">
        <div class="menu-item" onclick="toggleSubmenu(1)">1. î ÷ <span class="folder">..</span></div>
        <div id="submenu-1" class="submenu">
            <div class="menu-item">úé1</div>
            <div class="menu-item">úé2</div>
        </div>
        <div class="menu-item">2. ç äðdiv>
        <div class="menu-item">3. ääçåîë àé/div>
        <div class="menu-item" onclick="toggleSubmenu(2)">4. ñú <span class="folder">..</span></div>
        <div id="submenu-2" class="submenu">
            <div class="menu-item">ãçâú</div>
            <div class="menu-item">ãçâäò)</div>
        </div>
    </div>

    <script>
        function toggleSubmenu(id) {
            const submenu = document.getElementById(`submenu-${id}`);
            submenu.style.display = (submenu.style.display === 'block') ? 'none' : 'block';
        }
    </script>
</body>
</html>

