#!/usr/bin/env python


"""Send the contents of a directory as a MIME message."""

import os
import glob
import sys
import smtplib
# For guessing MIME type based on file name extension
import mimetypes

from optparse import OptionParser
from email.charset import Charset
from email import encoders
from email.message import Message
from email.mime.audio import MIMEAudio
from email.mime.base import MIMEBase
from email.mime.image import MIMEImage
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText

COMMASPACE = ', '

def main():
    parser = OptionParser(usage="""\
Send the contents of attached or body files as a MIME message.

Usage: %prog [options]

Unless the -o option is given, the email is sent by forwarding to your local
SMTP server, which then does the normal delivery process.  Your local machine
must be running an SMTP server.
""")
    parser.add_option('-a', '--attach',
                      type='string', action='store',metavar='ATTACH',
		      dest='attachments',	
                      help="""Mail the contents of the file list,
                      files separated by "," .""")
    parser.add_option('-b', '--body',
		     type='string',action='store',metavar='BODY',		
                     dest='mailbody',
		     help="""The content of the file will be sent as a mail body			Please use or body switch or attachment""") 	
    parser.add_option('-o', '--output',
                      type='string', action='store', metavar='FILE',
                      help="""Print the composed message to FILE instead of
                      sending the message to the SMTP server.""")
    parser.add_option('-m', '--mailsrv',
                      type='string', action='store', metavar='MAILSRV',
                      help="""SMTP :Outgoing mail server """)
    parser.add_option('-u', '--authusr',
                      type='string', action='store', metavar='AUTHUSR',
                      help="""SMTP account user name """)
    parser.add_option('-p', '--authpwd',
                      type='string', action='store', metavar='AUTHPWD',
                      help="""SMTP account password""")
    parser.add_option('-j', '--subject',
                      type='string', action='store', metavar='SUBJECT',
                      help="""Subject for a sending the message """)
    parser.add_option('-s', '--sender',
                      type='string', action='store', metavar='SENDER',
                      help='The value of the : header (required)')
    parser.add_option('-y', '--reply',
                      type='string', action='store', metavar='REPLY',
                      help='The value of the FROM : header (required)')
    parser.add_option('-r', '--recipient',
                      type='string', action='append', metavar='RECIPIENT',
                      default=[], dest='recipients',
                      help='A To: header value (at least one required)')
    opts, args = parser.parse_args()
    if not opts.sender or not opts.recipients:
        parser.print_help()
        sys.exit(1)
    if opts.attachments:
	attachs=""	
         #for fl in glob.glob(os.path.join('/',opts.attachments)):
	for fl in opts.attachments.split(","):
		attachs=attachs + fl + ","	 
            
        # print flist   
        # sys.exit(2)     
	flist = attachs.split(",")
	#print flist 
    else:
	flist=""
   # print flist  
    #if not flist:
	#sys.exit(1)
    # Create the enclosing (outer) message
    if not opts.reply:
   	opts.reply="pos" 

    outer = MIMEMultipart()
    outer['Subject'] = opts.subject
    outer['To'] = COMMASPACE.join(opts.recipients)
    outer['From'] = opts.reply
    outer.preamble = 'You will not see this in a MIME-aware mail reader.\n'
    outer.epilogue=''
   # print outer['To']
    #print opts.recipients
    #sys.exit(1)
    if not opts.mailbody:
    	bodyfile=""
    else:
	bodyfile=opts.mailbody
    if os.path.isfile(bodyfile):
    	bodytxt="""<html>
		<body>
		<p style="text-align: right;">
		""" 
   	body = MIMEMultipart('alternative')
    	fp = open(bodyfile)
    	for ln in fp:
    		bodytxt=bodytxt+ln+"<br>"
    	fp.close()
    	bodytxt+="""</p></body></html>""" 
            # Note: we should handle calculating the charse
    	body.attach(MIMEText(bodytxt, _subtype='html',_charset='iso8859-8'))
    
    	outer.attach(body) 


    for filename in flist:
	path = filename
        if not os.path.isfile(filename):
            continue
        # Guess the content type based on the file's extension.  Encoding
        # will be ignored, although we should check for simple things like
        # gzip'd or compressed files.
        ctype, encoding = mimetypes.guess_type(path)
        if ctype is None or encoding is not None:
            # No guess could be made, or the file is encoded (compressed), so
            # use a generic bag-of-bits type.
            ctype = 'application/octet-stream'
        maintype, subtype = ctype.split('/', 1)
        if maintype == 'text':
            fp = open(path)
            # Note: we should handle calculating the charset
            msg = MIMEText(fp.read(), _subtype='html',_charset='iso8859-8')
            fp.close()
        elif maintype == 'image':
            fp = open(path, 'rb')
            msg = MIMEImage(fp.read(), _subtype=subtype)
            fp.close()
        elif maintype == 'audio':
            fp = open(path, 'rb')
            msg = MIMEAudio(fp.read(), _subtype=subtype)
            fp.close()
        else:
            fp = open(path, 'rb')
            msg = MIMEBase(maintype, subtype,_charset='iso8859-8')
            msg.set_payload(fp.read())
            fp.close()
            # Encode the payload using Base64
            encoders.encode_base64(msg)
    
        # Set the filename parametre
        fi=filename.split('/')
#	print "".join(fi[-1:])
#	print filename	
        msg.add_header('Content-Disposition', 'attachment', filename="".join(fi[-1:]))
        outer.attach(msg)
        
        #outer.attach(body)  
    # Now send or store the message
   
    composed = outer.as_string()
    if opts.output:
        fp = open(opts.output, 'w')
        fp.write(composed)
        fp.close()
    else:
	user=opts.authusr
	passwd=opts.authpwd
        s =  smtplib.SMTP(opts.mailsrv,25)
	#s.set_debuglevel(1) # optional, good for debugging
    	s.ehlo()
    	#s.starttls()
    	s.ehlo() 	
	s.esmtp_features['auth'] = 'LOGIN AUTH'
   	s.login(user,passwd)
	smtplib.SMTP()
        #rcpt=[] 
        for rcpt in opts.recipients:
            rcpt+=","
           # print "The rcpt isa %s" % rcpt 
            s.sendmail(opts.sender, rcpt.split(","), composed)
        s.quit()


if __name__ == '__main__':
    main()

