package com.cav.taglibs.mumps;

import java.util.logging.Logger;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

import com.cav.mserver.MumpsQuery;

/**
 * A tag that performs body iff nesting query yielded empty result set 
 * 
 * @author uri
 */
public class MumpsWasNotEmptyTag extends TagSupport {

	private static Logger logger = Logger.getLogger(MumpsWasNotEmptyTag.class
			.getPackage().getName());

	public MumpsWasNotEmptyTag() {
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doStartTag() throws JspException {
		MumpsQueryTag queryTag = (MumpsQueryTag)findAncestorWithClass(
			this,
			MumpsQueryTag.class);
		if (queryTag == null) {
			throw new JspTagException(
					"A wasNotEmpty tag must be nested within a query tag.");
		}
		MumpsQuery query = queryTag.getQuery();
		if (!query.getResultSet().isEmpty()) {
			return EVAL_BODY_INCLUDE;
		}
		// else - not empty
		return SKIP_BODY;
	}
}