package com.cav.taglibs.mumps;

import java.text.MessageFormat;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * A tag that executes M code from JavaScript running on the client, on the 
 * M server.
 * @author uri
 */
public class MumpsServerExecTag extends TagSupport {

	/** The expression to run */
	private String expr;

	/** Whether to send only the current field value or all the fields */
	private Boolean currentField = Boolean.FALSE;

	/** Code to run, in order to save the M code to run for later execution */
	private static final MessageFormat M_SAVE_CODE = new MessageFormat(
			"D REMSAVE^%ZCAVJSP({0})");

	/** The javascript code to put in the page to run */
	private static final MessageFormat JS_RUN_CODE = new MessageFormat(
			"executeMumps(\"{0}\", {1}, {2}, {3})");

	/** The optional M variable to set before running the expression */
	private String varName;
	
	/** The value to set to the M variable, as JavaScript expression */
	private String varValue;

	/**
	 * Default constructor, for the bean.
	 */
	public MumpsServerExecTag() {
	}

	/**
	 * @return Returns the expression.
	 */
	public String getExpr() {
		return expr;
	}

	/**
	 * @param expr The expression to set.
	 */
	public void setExpr(String expr) {
		this.expr = expr;
	}

	
	/**
	 * @return Returns the currentField.
	 */
	public Boolean getCurrentField() {
		return currentField;
	}

	/**
	 * @param currentField The currentField to set.
	 */
	public void setCurrentField(Boolean currentField) {
		this.currentField = currentField;
	}

	
	/**
	 * @return Returns the varName.
	 */
	public String getVarName() {
		return varName;
	}

	/**
	 * @param varName The varName to set.
	 */
	public void setVarName(String varName) {
		this.varName = varName;
	}

	/**
	 * @return Returns the varValue.
	 */
	public String getVarValue() {
		return varValue;
	}

	/**
	 * @param varValue The varValue to set.
	 */
	public void setVarValue(String varValue) {
		this.varValue = varValue;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.SimpleTagSupport#doTag()
	 */
	public int doStartTag() throws JspException {
		MumpsSessionTag sessionTag = (MumpsSessionTag)findAncestorWithClass(
			this,
			MumpsSessionTag.class);
		if (sessionTag == null) {
			throw new JspTagException(
					"A serverExec tag must be nested within a session tag.");
		}
		JSPMumpsSession session = sessionTag.getSession();
		String key = session.exec(M_SAVE_CODE
				.format(new Object[] { JSPMumpsSession.toMString(expr) }));
		boolean setVariable = getVarName() != null && getVarValue() != null;
		String jsCode = JS_RUN_CODE.format(new Object[] { key,
				currentField.booleanValue() ? "this.name" : "undefined",
				setVariable ? '"' + getVarName() + '"' : "undefined",
				setVariable ? getVarValue() : "undefined", });
		try {
			pageContext.getOut().print(jsCode);
		} catch (Exception ex) {
			throw new JspException("IO problems");
		}
		return SKIP_BODY;
	}
}