package com.cav.taglibs.mumps;

import java.util.*;
import java.util.logging.Logger;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

import com.cav.mserver.MumpsQuery;

/**
 * A tag that iterates a Mumps query result, row by row.
 * 
 * @author uri
 */
public class MumpsForeachRowTag extends TagSupport {

	private static Logger logger = Logger.getLogger(MumpsForeachRowTag.class
			.getPackage().getName());

	private Iterator iterator;

	private List row;

	private int rowIndex = 0;

	private String varName = "_row";

	private JSPMumpsSession session;

	public MumpsForeachRowTag() {
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doAfterBody()
	 */
	public int doAfterBody() throws JspException {
		return nextRow();
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doEndTag() throws JspException {
		// We have to call release() explicitly, since it doesn't have to be 
		// called by the container each time, according to the spec
		release();
		return EVAL_PAGE;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doStartTag() throws JspException {
		MumpsQueryTag queryTag = (MumpsQueryTag)findAncestorWithClass(
			this,
			MumpsQueryTag.class);
		if (queryTag == null) {
			throw new JspTagException(
					"A foreachRow tag must be nested within a query tag.");
		}
		MumpsQuery query = queryTag.getQuery();
		iterator = query.getResultSet().iterator();
		MumpsSessionTag sessionTag = (MumpsSessionTag)findAncestorWithClass(
			this,
			MumpsSessionTag.class);
		session = sessionTag.getSession();
		return nextRow();
	}

	/**
	 * @return Returns the current row (or null, if none).
	 */
	public List getRow() {
		return row;
	}

	/**
	 * @return Returns the varName.
	 */
	public String getVarName() {
		return varName;
	}

	/**
	 * @return
	 */
	private int nextRow() {
		if (iterator.hasNext()) {
			row = (List)iterator.next();
			rowIndex++;
			pageContext.setAttribute(getVarName(), new Integer(rowIndex));
			session.set(getVarName().replaceAll("_", "%"), "" + rowIndex);
			return EVAL_BODY_AGAIN;
		}
		// else - no more rows
		return SKIP_BODY;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#release()
	 */
	public void release() {
		iterator = null;
		row = null;
		rowIndex = 0;
		session = null;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#setPageContext(javax.servlet.jsp.PageContext)
	 */
	public void setPageContext(PageContext pageContext) {
		super.setPageContext(pageContext);
		this.pageContext = pageContext;
	}

	/**
	 * @param varName The varName to set.
	 */
	public void setVarName(String varName) {
		this.varName = varName;
	}
}