package com.cav.taglibs.mumps;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * A tag that executes M code and (optionally) prints its output
 * @author uri
 */
public class MumpsExecTag extends TagSupport {

	private String expr;

	private Boolean silent = Boolean.FALSE;

	public MumpsExecTag() {
	}

	/**
	 * @return Returns the varName.
	 */
	public String getExpr() {
		return expr;
	}

	/**
	 * @param varName The varName to set.
	 */
	public void setExpr(String varName) {
		this.expr = varName;
	}

	/**
	 * @return Returns the silent.
	 */
	public Boolean getSilent() {
		return silent;
	}

	/**
	 * @param silent The silent to set.
	 */
	public void setSilent(Boolean silent) {
		this.silent = silent;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.SimpleTagSupport#doTag()
	 */
	public int doStartTag() throws JspException {
		MumpsSessionTag sessionTag = (MumpsSessionTag)findAncestorWithClass(
			this,
			MumpsSessionTag.class);
		if (sessionTag == null) {
			throw new JspTagException(
					"An exec tag must be nested within a session tag.");
		}
		JSPMumpsSession session = sessionTag.getSession();
		String value = session.exec(expr);
		if (!silent.booleanValue()) {
			try {
				pageContext.getOut().print(value);
			} catch (Exception ex) {
				throw new JspException("IO problems");
			}
		}
		return SKIP_BODY;
	}
}