package com.cav.mserver;

import java.util.logging.*;

import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

/**
 * A Mumps session pool singletone.
 * @author Uri Schor
 */
public class MumpsSessionPool {

	private static Logger logger = Logger.getLogger(MumpsSessionPool.class
			.getPackage().getName());

	/** The singletone */
	private static ObjectPool pool;

	/**
	 * Get the pool instance.
	 * @return The pool instance.
	 */
	public static synchronized ObjectPool instance() {
		if (pool == null) {
			// Initialize logger, in case it's not initialized yetz
			LoggingConfiguration.init();
			
			int maxActive = Config.getInt("pool.maxActive", 10);
			int maxWait = Config.getInt("pool.maxWaitSecs", 10) * 1000;
			int initIdle = Config.getInt("pool.initIdle", 5);
			int maxIdle = Config.getInt("pool.maxIdle", 5);
			logger.info("Creating pool: maxActive=" + maxActive + ", initIdle="
						+ initIdle + ", maxWait=" + maxWait);
			
			// If telnet.host property doesn't exist use local mumps sessions (mux):
			Class mumpsSessionClass = 
			    ( Config.getString("telnet.host") == null ) ?
			            MuxSession.class : MumpsTelnetSession.class;
		           
			            
			pool = new GenericObjectPool(new PoolableMumpsSessionFactory(
			        mumpsSessionClass), maxActive,
					GenericObjectPool.WHEN_EXHAUSTED_BLOCK, maxWait, maxIdle,
					false, true);
			((GenericObjectPool)pool).setTestWhileIdle(true);
			int refreshTime = Config.getInt("pool.refreshTime", 90) * 1000;
			((GenericObjectPool)pool)
					.setTimeBetweenEvictionRunsMillis(refreshTime);
			// create the initial idle instances
			logger.info("Initializing idle sessions");
			Object[] idleObjs = new Object[initIdle];
			try {
				for (int i = 0; i < initIdle; ++i) {
					idleObjs[i] = pool.borrowObject();
				}
				for (int i = 0; i < initIdle; ++i) {
					pool.returnObject(idleObjs[i]);
				}
			}
			catch (Exception e) {
				logger.log(
					Level.SEVERE,
					"Error borrowing or returning initial idle sessions",
					e);
			}
			logger.info("Idle init done");
		}
		return pool;
	}

}