package com.cav.mserver;

import java.io.*;
import java.io.InputStream;
import java.util.Map;

/**
 * An interface for Mumps session (AKA job).
 * @author Uri Schor
 */
public interface MumpsSession {

	/**
	 * Check whether this job is valid.
	 * @return true if job is running, false if terminated
	 */
	public boolean validate();
	
	/**
	 * Close the session.
	 */
	public void close();
	
	/**
	 * Initialize the session.
	 */
	public void init() throws IOException;
	
	/**
	 * Run a Mumps command after setting the variables passed as parameters.
	 * @param command A label to run.
	 * @param parameters Variables map, whereas each key is a variable name that
	 * will be set to its corresponding value before the command is run.
	 * @return A stream with the command output
	 */
	public InputStream execute(String command, Map parameters);
	
}
