/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.ChartHolder;
import de.laures.cewolf.ChartImage;
import de.laures.cewolf.ChartValidationException;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.PostProcessingException;
import de.laures.cewolf.event.ChartImageRenderListener;
import de.laures.cewolf.util.RenderedImage;
import de.laures.cewolf.util.Renderer;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChartImageDefinition
implements ChartImage,
ChartHolder,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$de$laures$cewolf$taglib$ChartImageDefinition == null ? (class$de$laures$cewolf$taglib$ChartImageDefinition = ChartImageDefinition.class$("de.laures.cewolf.taglib.ChartImageDefinition")) : class$de$laures$cewolf$taglib$ChartImageDefinition));
    private final ChartHolder chartHolder;
    private final int height;
    private final int width;
    private final int type;
    private final String mimeType;
    private final transient Date timeoutTime;
    private RenderedImage renderedImage;
    static /* synthetic */ Class class$de$laures$cewolf$taglib$ChartImageDefinition;

    public ChartImageDefinition(ChartHolder ch, int width, int height, int type, String mimeType, int timeout) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("ChartImage with height or width <= 0 is illegal");
        }
        this.chartHolder = ch;
        this.width = width;
        this.height = height;
        this.type = type;
        this.mimeType = mimeType;
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(13, timeout);
        this.timeoutTime = cal.getTime();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getType() {
        return this.type;
    }

    public Object getChart() throws DatasetProduceException, ChartValidationException, PostProcessingException {
        return this.chartHolder.getChart();
    }

    public Object getDataset() throws DatasetProduceException {
        return this.chartHolder.getDataset();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        log.debug((Object)(this + " finalized."));
    }

    public Object getRenderingInfo() throws CewolfException {
        this.ensureRendered();
        return this.renderedImage.renderingInfo;
    }

    public byte[] getBytes() throws CewolfException {
        this.ensureRendered();
        return this.renderedImage.data;
    }

    private void ensureRendered() throws CewolfException {
        if (this.renderedImage == null) {
            this.renderedImage = Renderer.render(this, this.chartHolder.getChart());
            this.onImageRendered(this.renderedImage);
        }
    }

    public int getSize() throws CewolfException {
        this.ensureRendered();
        return this.renderedImage.data.length;
    }

    public Date getTimeoutTime() {
        return this.timeoutTime;
    }

    private void onImageRendered(RenderedImage renderedImage) {
        if (this.chartHolder instanceof ChartImageRenderListener) {
            ((ChartImageRenderListener)((Object)this.chartHolder)).onImageRendered(renderedImage);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

