/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.storage;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.ChartImage;
import de.laures.cewolf.Storage;
import de.laures.cewolf.taglib.util.KeyGenerator;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractSessionStorage
implements Storage {
    private static final Log log = LogFactory.getLog((Class)(class$de$laures$cewolf$storage$AbstractSessionStorage == null ? (class$de$laures$cewolf$storage$AbstractSessionStorage = AbstractSessionStorage.class$("de.laures.cewolf.storage.AbstractSessionStorage")) : class$de$laures$cewolf$storage$AbstractSessionStorage));
    static /* synthetic */ Class class$de$laures$cewolf$storage$AbstractSessionStorage;

    public String storeChartImage(ChartImage cid, PageContext pageContext) throws CewolfException {
        if (this.contains(cid, pageContext)) {
            return this.getKey(cid);
        }
        log.debug((Object)("storing chart " + cid));
        HttpSession session = pageContext.getSession();
        return this.storeChartImage(cid, session);
    }

    public ChartImage getChartImage(String id, HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (ChartImage)session.getAttribute(id);
    }

    public boolean contains(ChartImage cid, PageContext pageContext) {
        return pageContext.getSession().getAttribute(this.getKey(cid)) != null;
    }

    public final String getKey(ChartImage cid) {
        return String.valueOf(KeyGenerator.generateKey((Serializable)((Object)cid)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String storeChartImage(ChartImage cid, HttpSession session) throws CewolfException {
        String sessionKey = this.getKey(cid);
        HttpSession httpSession = session;
        synchronized (httpSession) {
            session.setAttribute(sessionKey, this.getCacheObject(cid));
        }
        return sessionKey;
    }

    public String removeChartImage(String imgKey, HttpServletRequest request) throws CewolfException {
        HttpSession session = request.getSession();
        if (session == null) {
            return imgKey;
        }
        return this.removeChartImage(imgKey, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String removeChartImage(String cid, HttpSession session) throws CewolfException {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            session.removeAttribute(cid);
        }
        return cid;
    }

    protected abstract Object getCacheObject(ChartImage var1) throws CewolfException;

    public void init(ServletContext servletContext) throws CewolfException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

