/*
 * Decompiled with CFR 0.152.
 */
package com.genorder.resources;

import com.genorder.bean.Address;
import com.genorder.bean.OrderContact;
import com.genorder.bean.OrderItem;
import com.genorder.bean.OrderLog;
import com.genorder.bean.OrderRestaurant;
import com.genorder.bean.OrderSource;
import com.genorder.bean.OrderStatus;
import com.genorder.bean.Payment;
import com.genorder.bean.PaymentCibus;
import com.genorder.bean.PaymentCreditCardDets;
import com.genorder.bean.RestPosParams;
import com.genorder.resources.GetOrderDetailtsExV2;
import com.openrest.olo.charges.Charge;
import com.openrest.olo.charges.OrderCharge;
import com.openrest.olo.dispatches.DeliveryDispatch;
import com.openrest.order.beans.ItemDetsV2;
import com.openrest.order.beans.OrderAndCredit;
import com.openrest.order.beans.SoMenuMap;
import com.toorder.resources.ToOrderFormatUtils;
import com.wix.pay.creditcard.CreditCard;
import com.wix.pay.creditcard.CreditCardOptionalFields;
import com.wix.pay.creditcard.PublicCreditCardOptionalFields;
import com.wix.restaurants.payments.CibusPayment;
import com.wix.restaurants.payments.CreditcardPayment;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class GetSoOrderDetailtsExV2
implements GetOrderDetailtsExV2<OrderAndCredit> {
    @Override
    public String getOrderId() {
        return "";
    }

    @Override
    public Address getOrderAddress(OrderAndCredit om) {
        String city = "TAW";
        String neightbourhood = "";
        String street = "";
        String hous_num = "";
        String entrance = "";
        String floor = "";
        String appartment = "";
        String addr_comment = "";
        Double gps_geo_lat = 0.0;
        Double gps_geo_lng = 0.0;
        if (om.getOrder().delivery instanceof DeliveryDispatch) {
            DeliveryDispatch odlv = (DeliveryDispatch)om.getOrder().delivery;
            city = ToOrderFormatUtils.frmString(odlv.address.city);
            neightbourhood = "";
            street = ToOrderFormatUtils.frmString(odlv.address.street);
            hous_num = ToOrderFormatUtils.frmString(odlv.address.number);
            entrance = ToOrderFormatUtils.frmString(odlv.address.entrance);
            floor = ToOrderFormatUtils.frmString(odlv.address.floor);
            appartment = ToOrderFormatUtils.frmString(odlv.address.apt);
            String onArriveComment = "";
            if ("phone".equals(odlv.address.onArrival)) {
                onArriveComment = "\u05d1\u05d4\u05d2\u05e2\u05d4  \u05d4\u05ea\u05e7\u05e9\u05e8\u05d5 \u05d0\u05dc\u05d9";
            } else if ("buzz".equals(odlv.address.onArrival)) {
                onArriveComment = "\u05d1\u05d4\u05d2\u05e2\u05d4 \u05dc\u05e6\u05dc\u05e6\u05dc \u05d1\u05d3\u05dc\u05ea   ";
            }
            addr_comment = ToOrderFormatUtils.frmString(odlv.address.comment) + " , " + ToOrderFormatUtils.frmString(onArriveComment);
            gps_geo_lat = odlv.address.latLng.lat;
            gps_geo_lng = odlv.address.latLng.lng;
        }
        return new Address(city, neightbourhood, street, hous_num, entrance, floor, appartment, addr_comment, gps_geo_lat, gps_geo_lng);
    }

    @Override
    public Date getOrderDateDeliveryTime(OrderAndCredit om) {
        Date order_dlv_time = om.getOrder().delivery.time;
        return order_dlv_time;
    }

    @Override
    public List<OrderContact> getOrderContacts(OrderAndCredit om) {
        String contact_firstname = ToOrderFormatUtils.frmString(om.getOrder().contact.firstName);
        String contact_lastname = ToOrderFormatUtils.frmString(om.getOrder().contact.lastName);
        String contact_phone = ToOrderFormatUtils.frmPhone(om.getOrder().contact.phone);
        String contact_cellphone = ToOrderFormatUtils.frmPhone(om.getOrder().contact.phone);
        String contact_email = ToOrderFormatUtils.frmString(om.getOrder().contact.email);
        String contact_fax = ToOrderFormatUtils.frmPhone(om.getOrder().contact.fax);
        String contact_id = "";
        OrderContact oc = new OrderContact(contact_firstname, contact_lastname, contact_phone, contact_cellphone, contact_email, contact_fax, contact_id);
        LinkedList<OrderContact> ord_contact_list = new LinkedList<OrderContact>();
        ord_contact_list.add(oc);
        return ord_contact_list;
    }

    @Override
    public List<OrderItem> getOrderItemsV2(OrderAndCredit om, SoMenuMap somm) {
        LinkedList<OrderItem> gen_order_items = new LinkedList<OrderItem>();
        int item_poz = 0;
        for (com.openrest.v1_1.OrderItem oi : om.getOrder().orderItems) {
            ++item_poz;
            ItemDetsV2 iDets = new ItemDetsV2().setItemDetails(oi, somm);
            String itemID = ToOrderFormatUtils.frmString(iDets.getItemId());
            String itemPosID = ToOrderFormatUtils.frmString(iDets.getItemPosID());
            String itemName = ToOrderFormatUtils.frmString(iDets.getItemName());
            String itemPrice = iDets.getItemPrice();
            String itemComment = ToOrderFormatUtils.frmString(iDets.getItemComment());
            String itemQty = "1.00";
            String itemDiscount = "0.00";
            String itemTotal = itemPrice;
            OrderItem gen_order_item = new OrderItem(item_poz, 0, "", itemID, itemPosID, itemName, itemPrice, itemQty, itemDiscount, itemTotal, itemComment);
            gen_order_items.add(gen_order_item);
            for (List varChoices : oi.variationsChoices) {
                for (com.openrest.v1_1.OrderItem varChoice : varChoices) {
                    OrderItem gen_order_var;
                    ItemDetsV2 varDets = new ItemDetsV2().setItemDetails(varChoice, somm);
                    ++item_poz;
                    String varId = ToOrderFormatUtils.frmString(varDets.getItemId());
                    String varPosID = ToOrderFormatUtils.frmString(varDets.getItemPosID());
                    String varName = ToOrderFormatUtils.frmString(varDets.getItemName());
                    String varPrice = varDets.getItemPrice();
                    String varComment = ToOrderFormatUtils.frmString(varDets.getItemComment());
                    String varQty = "1.00";
                    String varDiscount = "0.00";
                    String varTotal = varPrice;
                    if (itemPosID.contains("\u05d5\u05d9\u05e8\u05d8\u05d5\u05d0\u05dc\u05d9")) {
                        varComment = varComment + " ";
                        varComment = varComment + itemComment;
                        itemComment = "";
                        gen_order_var = new OrderItem(item_poz, 0, "", varId, varPosID, varName, varPrice, varQty, varDiscount, varTotal, varComment);
                        gen_order_items.add(gen_order_var);
                    } else {
                        gen_order_var = new OrderItem(item_poz, 1, "V", varId, varPosID, varName, varPrice, varQty, varDiscount, varTotal, varComment);
                        gen_order_items.add(gen_order_var);
                    }
                    for (List varOfvarChoices : varChoice.variationsChoices) {
                        for (com.openrest.v1_1.OrderItem varOfvarChoice : varOfvarChoices) {
                            OrderItem gen_order_var_of_var;
                            ItemDetsV2 varOfvarDets = new ItemDetsV2().setItemDetails(varOfvarChoice, somm);
                            ++item_poz;
                            String varOfvarId = ToOrderFormatUtils.frmString(varOfvarDets.getItemId());
                            String varOfvarPosID = ToOrderFormatUtils.frmString(varOfvarDets.getItemPosID());
                            String varOfvarName = ToOrderFormatUtils.frmString(varOfvarDets.getItemName());
                            String varOfvarPrice = varOfvarDets.getItemPrice();
                            String varOfvarComment = ToOrderFormatUtils.frmString(varOfvarDets.getItemComment());
                            String varOfvarQty = "1.00";
                            String varOfvarDiscount = "0.00";
                            String varOfvarTotal = varOfvarPrice;
                            if (itemPosID.contains("\u05d5\u05d9\u05e8\u05d8\u05d5\u05d0\u05dc\u05d9")) {
                                gen_order_var_of_var = new OrderItem(item_poz, 1, "V", varOfvarId, varOfvarPosID, varOfvarName, varOfvarPrice, varOfvarQty, varOfvarDiscount, varOfvarTotal, varOfvarComment);
                                gen_order_items.add(gen_order_var_of_var);
                            } else {
                                gen_order_var_of_var = new OrderItem(item_poz, 2, "VOV", varOfvarId, varOfvarPosID, varOfvarName, varOfvarPrice, varOfvarQty, varOfvarDiscount, varOfvarTotal, varOfvarComment);
                                gen_order_items.add(gen_order_var_of_var);
                            }
                            for (List lvl4Choices : varOfvarChoice.variationsChoices) {
                                for (com.openrest.v1_1.OrderItem lvl4Choice : lvl4Choices) {
                                    ItemDetsV2 lvl4varDets = new ItemDetsV2().setItemDetails(lvl4Choice, somm);
                                    ++item_poz;
                                    String lvl4varId = ToOrderFormatUtils.frmString(lvl4varDets.getItemId());
                                    String lvl4varPosID = ToOrderFormatUtils.frmString(lvl4varDets.getItemPosID());
                                    String lvl4varName = ToOrderFormatUtils.frmString(lvl4varDets.getItemName());
                                    String lvl4varPrice = lvl4varDets.getItemPrice();
                                    String lvl4varComment = ToOrderFormatUtils.frmString(lvl4varDets.getItemComment());
                                    String lvl4varQty = "1.00";
                                    String lvl4varDiscount = "0.00";
                                    String lvl4varTotal = lvl4varPrice;
                                    OrderItem gen_orderlvl4Var = new OrderItem(item_poz, 3, "VOV", lvl4varId, lvl4varPosID, lvl4varName, lvl4varPrice, lvl4varQty, lvl4varDiscount, lvl4varTotal, lvl4varComment);
                                    gen_order_items.add(gen_orderlvl4Var);
                                }
                            }
                        }
                    }
                }
            }
        }
        return gen_order_items;
    }

    @Override
    public OrderLog getOrderLog(OrderAndCredit om) {
        return new OrderLog();
    }

    @Override
    public OrderRestaurant getOrderRestaurant(OrderAndCredit om) throws Exception {
        String rest_source_id = ToOrderFormatUtils.frmString(om.getOrder().restaurantId);
        String rest_local_id = "";
        return new OrderRestaurant(rest_source_id, rest_local_id, rest_source_id);
    }

    @Override
    public String getToOrderRestCode(String SourceRestCod) throws Exception {
        return "";
    }

    @Override
    public OrderSource getOrderSource(OrderAndCredit om) {
        return new OrderSource(15, "SeferHaOhel", om.getOrder().id);
    }

    @Override
    public OrderStatus getOrderStatus(OrderAndCredit om) {
        return new OrderStatus(1, "", "", "", "");
    }

    @Override
    public List<Payment> getOrderPayment(OrderAndCredit om) {
        LinkedList<Payment> gen_order_payment = new LinkedList<Payment>();
        for (com.wix.restaurants.payments.Payment pay : om.getOrder().payments) {
            String amount = ToOrderFormatUtils.frmAgorotToNis(pay.amount.toString());
            Payment gen_order_paytrn = new Payment();
            if (pay instanceof CreditcardPayment) {
                CreditcardPayment paycrd = new CreditcardPayment();
                paycrd = (CreditcardPayment)pay;
                CreditCard cc_dets = om.getCards().get(paycrd.cardToken.token());
                String cc_card_type = ToOrderFormatUtils.frmString("1");
                String cc_number = "";
                String cc_owner_id = "";
                String cc_cvv = "";
                String cc_owner_name = "";
                String cc_owner_phone = "";
                if (cc_dets != null) {
                    cc_number = ToOrderFormatUtils.frmString(cc_dets.number());
                    if (((CreditCardOptionalFields)cc_dets.additionalFields().get()).csc().isDefined()) {
                        cc_cvv = ToOrderFormatUtils.frmString((String)((CreditCardOptionalFields)cc_dets.additionalFields().get()).csc().get());
                    }
                    if (((PublicCreditCardOptionalFields)((CreditCardOptionalFields)cc_dets.additionalFields().get()).publicFields().get()).holderId().isDefined()) {
                        cc_owner_id = ToOrderFormatUtils.frmString((String)((PublicCreditCardOptionalFields)((CreditCardOptionalFields)cc_dets.additionalFields().get()).publicFields().get()).holderId().get());
                    }
                    if (((PublicCreditCardOptionalFields)((CreditCardOptionalFields)cc_dets.additionalFields().get()).publicFields().get()).holderName().isDefined()) {
                        cc_owner_name = ToOrderFormatUtils.frmString((String)((PublicCreditCardOptionalFields)((CreditCardOptionalFields)cc_dets.additionalFields().get()).publicFields().get()).holderName().get());
                    }
                } else if (paycrd.cardToken.creditCard().additionalFields().isDefined()) {
                    if (((PublicCreditCardOptionalFields)paycrd.cardToken.creditCard().additionalFields().get()).holderId().isDefined()) {
                        cc_owner_id = ToOrderFormatUtils.frmString((String)((PublicCreditCardOptionalFields)paycrd.cardToken.creditCard().additionalFields().get()).holderId().get());
                    }
                    if (((PublicCreditCardOptionalFields)paycrd.cardToken.creditCard().additionalFields().get()).holderName().isDefined()) {
                        cc_owner_name = ToOrderFormatUtils.frmString((String)((PublicCreditCardOptionalFields)paycrd.cardToken.creditCard().additionalFields().get()).holderName().get());
                    }
                }
                String cc_mounth = String.valueOf(paycrd.cardToken.creditCard().expiration().month());
                cc_mounth = String.format("%2s", cc_mounth).replace(' ', '0');
                String cc_year = String.valueOf(paycrd.cardToken.creditCard().expiration().year());
                String cc_exp = cc_mounth + "/" + cc_year.substring(2);
                PaymentCreditCardDets gen_order_credit = new PaymentCreditCardDets(cc_card_type, cc_number, cc_exp, cc_cvv, cc_owner_name, cc_owner_id, cc_owner_phone);
                gen_order_paytrn.setAmount(amount);
                gen_order_paytrn.setPayment_id(3);
                gen_order_paytrn.setPayment_type("CreditCard");
                gen_order_paytrn.setPayment_card_dets(gen_order_credit);
                gen_order_payment.add(gen_order_paytrn);
                continue;
            }
            if (pay instanceof CibusPayment) {
                PaymentCibus paycibus = new PaymentCibus(5, "Cibus", amount);
                gen_order_payment.add(paycibus);
                continue;
            }
            gen_order_paytrn.setAmount(amount);
            gen_order_paytrn.setPayment_id(1);
            gen_order_paytrn.setPayment_type("Cash");
            gen_order_payment.add(gen_order_paytrn);
        }
        return gen_order_payment;
    }

    @Override
    public String getOrderDeliveryFee(OrderAndCredit om) {
        String dlvfee = ToOrderFormatUtils.frmAgorotToNis(om.getOrder().delivery.charge.toString());
        return dlvfee;
    }

    @Override
    public String getOrderTip(OrderAndCredit om, SoMenuMap somm) {
        int totalCharges = 0;
        HashMap<String, Charge> chargesMap = new HashMap<String, Charge>();
        for (Charge charge : somm.getChargesV2()) {
            chargesMap.put(charge.id, charge);
        }
        int totalTip = 0;
        for (OrderCharge orderCharge : om.getOrder().orderCharges) {
            Charge charge = (Charge)chargesMap.get(orderCharge.chargeId);
            switch (charge.type) {
                case "tip": {
                    totalTip += orderCharge.amount.intValue();
                    break;
                }
                case "discount": {
                    totalCharges += orderCharge.amount.intValue();
                    break;
                }
            }
        }
        return ToOrderFormatUtils.frmAgorotToNis(Integer.toString(totalTip));
    }

    @Override
    public String getOrderDiscount(OrderAndCredit om, SoMenuMap somm) {
        int totalDiscount = 0;
        HashMap<String, Charge> chargesMap = new HashMap<String, Charge>();
        for (Charge charge : somm.getChargesV2()) {
            chargesMap.put(charge.id, charge);
        }
        int totalTip = 0;
        if (om.getOrder().orderCharges == null) {
            return "" + totalTip;
        }
        for (OrderCharge orderCharge : om.getOrder().orderCharges) {
            Charge charge = (Charge)chargesMap.get(orderCharge.chargeId);
            switch (charge.type) {
                case "tip": {
                    totalTip += orderCharge.amount.intValue();
                    break;
                }
                case "discount": {
                    totalDiscount += orderCharge.amount.intValue();
                    break;
                }
            }
        }
        return ToOrderFormatUtils.frmAgorotToNis(Integer.toString(totalDiscount *= -1));
    }

    @Override
    public String getOrderTotal(OrderAndCredit om) {
        String total = ToOrderFormatUtils.frmAgorotToNis(om.getOrder().price.toString());
        return total;
    }

    @Override
    public String getOrderComment(OrderAndCredit om) {
        String order_comment = ToOrderFormatUtils.frmString(om.getOrder().comment);
        return order_comment;
    }

    @Override
    public RestPosParams getRestPosParams(OrderAndCredit om) {
        return new RestPosParams();
    }

    @Override
    public int getNumOfDinners(OrderAndCredit om) {
        int takeoutPack = om.getOrder().takeoutPacks == null ? 0 : om.getOrder().takeoutPacks;
        return takeoutPack;
    }
}

