/*
 * Decompiled with CFR 0.152.
 */
package com.frsvision.bean;

import com.toorder.resources.DBConnector;
import java.util.LinkedHashMap;

public class FrsvisionParams {
    private String restSoId;
    private String restFrsvisionId;
    private String branchFrsVisionId;
    private String branchIpAddr;
    private String restDeliveryFeeItem;

    public FrsvisionParams() {
    }

    public FrsvisionParams(String restSoId) throws Exception {
        this.restSoId = restSoId;
        this.branchFrsVisionId = this.getBranchFrsId(restSoId);
        this.restFrsvisionId = this.restFrsvisionId;
        this.branchIpAddr = this.getPosIpAdrr(restSoId);
        this.restDeliveryFeeItem = this.getDlvFeeItem(restSoId);
    }

    private String getPosIpAdrr(String restSoId) throws Exception {
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        String pos_ip = dbc.execute("W $G(^W3SOR2FRS(\"" + restSoId + "\",\"IP\"))", global_map);
        if (pos_ip.equals("[]")) {
            throw new Exception("Error Get POS IP Address");
        }
        return pos_ip;
    }

    private String getBranchFrsId(String restSoId) throws Exception {
        String resp = "";
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        resp = dbc.execute("W $G(^[$$^W3MAIN]W3SOR2FRS(\"" + restSoId + "\")) ", global_map);
        if (resp.equals("[]")) {
            throw new Exception("Restaurant not connected to POS DB");
        }
        return resp;
    }

    private String getDlvFeeItem(String restSoId) throws Exception {
        String resp = "";
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        resp = dbc.execute("W $G(^W3SOR2FRS(\"" + restSoId + "\",\"DLVFEEITEM\"))", global_map);
        if (resp.equals("[]")) {
            throw new Exception("Delivery Fee Item not set in DB");
        }
        return resp;
    }

    public String getRestId() {
        return this.getRestSoId();
    }

    public void setRestSoId(String restSoId) {
        this.restSoId = restSoId;
    }

    public String getBranchIpAddr() {
        return this.branchIpAddr;
    }

    public void setBranchIpAddr(String branchIpAddr) {
        this.branchIpAddr = branchIpAddr;
    }

    public String getRestDeliveryFeeItem() {
        return this.restDeliveryFeeItem;
    }

    public void setRestDeliveryFeeItem(String restDeliveryFeeItem) {
        this.restDeliveryFeeItem = restDeliveryFeeItem;
    }

    public String getRestSoId() {
        return this.restSoId;
    }

    public String getRestFrsvisionId() {
        return this.restFrsvisionId;
    }

    public void setRestFrsvisionId(String restFrsvisionId) {
        this.restFrsvisionId = restFrsvisionId;
    }

    public String getBranchFrsVisionId() {
        return this.branchFrsVisionId;
    }

    public void setBranchFrsVisionId(String branchFrsVisionId) {
        this.branchFrsVisionId = branchFrsVisionId;
    }
}

