/*
 * Decompiled with CFR 0.152.
 */
package com.cav.mserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TelnetClient {
    private static Logger logger = Logger.getLogger((class$com$cav$mserver$TelnetClient == null ? (class$com$cav$mserver$TelnetClient = TelnetClient.class$("com.cav.mserver.TelnetClient")) : class$com$cav$mserver$TelnetClient).getPackage().getName());
    private boolean connected = false;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private PrintWriter outWriter;
    public static boolean sendEnterOnLogin = false;
    public static final int OS_UNIX = 1;
    public static final int OS_NT = 2;
    public static final int TELNET_PORT = 23;
    public static final String TELNET_DISCONNECTED = "TELNET SESSION DISCONNECTED!";
    private static final String USER_PROMPT_UNIX = "login: ";
    private static final String USER_PROMPT_NT = "Username: ";
    private static final String PASSWD_PROMPT = "Password:";
    private static final String CAV_JAVA_PROMPT = "~~~> ";
    private static final String MENU_PROMPT = "dlert ywd";
    private static final String MENU_ENTRY_KEY = "CavJava";
    private static final String TERM = "dumb";
    public static final String LICENCE_EXCEEDED_MESSAGE = "LICENSE LIMIT EXCEEDED";
    public static final String USER_EXCEEDED_MESSAGE = "ABOVE SESSION LIMITS";
    static /* synthetic */ Class class$com$cav$mserver$TelnetClient;

    public TelnetClient(String host, int port) throws IOException {
        this(host, port, 0);
    }

    public TelnetClient(String host, int port, int timeout) throws IOException {
        logger.info("Connecting to host: " + host + " port: " + port);
        try {
            this.socket = new Socket();
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(timeout);
            this.socket.connect(new InetSocketAddress(host, port), timeout);
        }
        catch (ConnectException e) {
            logger.log(Level.SEVERE, "Error connecting", e);
            throw e;
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (NoRouteToHostException e) {
            throw new IOException(TELNET_DISCONNECTED);
        }
        catch (IOException e) {
            throw e;
        }
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        this.outWriter = new PrintWriter(this.outputStream, true);
        this.connected = true;
    }

    public void disconnect() throws Exception {
        if (!this.connected) {
            return;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.inputStream = null;
        this.outputStream = null;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public boolean login(String user, String passwd) throws IOException {
        int os;
        if (sendEnterOnLogin) {
            this.println("");
        }
        if (this.waitForString(USER_PROMPT_UNIX, true, USER_PROMPT_NT)) {
            os = 1;
            logger.info("UNIX identified");
        } else {
            os = 2;
            logger.info("NT identified");
        }
        this.println(user);
        switch (this.waitForString(PASSWD_PROMPT, true, MENU_PROMPT, true, true)) {
            case 0: {
                logger.info("Got menu instead of password!");
                this.handleMenuPrompt();
                return true;
            }
            case 1: {
                this.println(passwd);
                break;
            }
            case 2: {
                this.handleUnixOrMumpsPrompt();
                return true;
            }
            case 3: {
                return true;
            }
        }
        logger.info("Password entered");
        if (os == 2) {
            switch (this.waitForString(CAV_JAVA_PROMPT, true, "User authorization failure", true, true)) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    logger.info("got the Mumps prompt");
                    this.println("D ^MWRAP");
                    this.waitForString(CAV_JAVA_PROMPT, true);
                    break;
                }
                case 3: {
                    return true;
                }
            }
        } else {
            logger.info("Checking if login succeeded");
            switch (this.waitForString(MENU_PROMPT, true, "Login incorrect", true, true)) {
                case 0: {
                    return false;
                }
                case 1: {
                    this.handleMenuPrompt();
                    return true;
                }
                case 2: {
                    this.handleUnixOrMumpsPrompt();
                    return true;
                }
                case 3: {
                    return true;
                }
            }
        }
        return true;
    }

    private void handleMenuPrompt() throws IOException {
        logger.info("Got the menu prompt");
        this.println(MENU_ENTRY_KEY);
        this.waitForString(CAV_JAVA_PROMPT, true);
    }

    private void handleUnixOrMumpsPrompt() throws IOException {
        logger.info("Got some prompt, need to test with tty");
        this.println("tty");
        if (this.waitForString("/", false, "^")) {
            logger.info("Got the Unix prompt");
            this.println("mux ^MWRAP");
        } else {
            logger.info("Got the Mumps prompt");
            this.println("D ^MWRAP");
        }
        this.waitForString(CAV_JAVA_PROMPT, true);
    }

    private void print(char c) throws IOException {
        if (c == '\n') {
            this.print('\r');
        }
        this.outputStream.write(c);
        this.outputStream.flush();
    }

    private void print(String s) throws IOException {
        if (this.outWriter == null) {
            throw new IOException(TELNET_DISCONNECTED);
        }
        this.outWriter.print(s);
        if (this.outWriter.checkError()) {
            throw new IOException(TELNET_DISCONNECTED);
        }
    }

    private void println(String s) throws IOException {
        if (this.outWriter == null) {
            throw new IOException(TELNET_DISCONNECTED);
        }
        this.outWriter.println(s);
        if (this.outWriter.checkError()) {
            throw new IOException(TELNET_DISCONNECTED);
        }
    }

    private boolean waitForString(String str, boolean handleIAC) throws IOException {
        return this.waitForString(str, handleIAC, "");
    }

    private boolean waitForString(String str, boolean handleIAC, String falseString) throws IOException {
        return this.waitForString(str, handleIAC, falseString, false) == 1;
    }

    private int waitForString(String str, boolean handleIAC, String falseString, boolean stopOnUnixPrompt) throws IOException {
        return this.waitForString(str, handleIAC, falseString, stopOnUnixPrompt, false);
    }

    private int waitForString(String str, boolean handleIAC, String falseString, boolean stopOnUnixPrompt, boolean stopOnCavJavaPrompt) throws IOException {
        char[] chars = str.toCharArray();
        char[] licstr = LICENCE_EXCEEDED_MESSAGE.toCharArray();
        char[] usrstr = USER_EXCEEDED_MESSAGE.toCharArray();
        char[] falseStr = falseString.toCharArray();
        int j = 0;
        int k = 0;
        int u = 0;
        int tildeCount = 0;
        boolean unixPromptReceived = false;
        logger.info("Waiting for string: '" + str + "'");
        int i = 0;
        while (i < chars.length) {
            int charCode = this.inputStream.read();
            if (charCode == -1) {
                logger.severe("Telnet session disconnected from the server");
                throw new IOException(TELNET_DISCONNECTED);
            }
            char c = (char)charCode;
            if (stopOnCavJavaPrompt && c == '>' && tildeCount == 3) {
                return 3;
            }
            tildeCount = c == '~' ? ++tildeCount : 0;
            if (c != ' ' && c != '\u0000' && c != '\t') {
                unixPromptReceived = false;
            }
            if (stopOnUnixPrompt && (c == '$' || c == '%' || c == '#' || c == '>')) {
                unixPromptReceived = true;
            }
            if (handleIAC) {
                this.handleIAC(c);
            }
            i = c == chars[i] ? ++i : 0;
            if (c == licstr[j]) {
                if (++j == licstr.length) {
                    throw new IOException(LICENCE_EXCEEDED_MESSAGE);
                }
            } else {
                j = 0;
            }
            if (c == usrstr[u]) {
                if (++u == usrstr.length) {
                    throw new IOException(USER_EXCEEDED_MESSAGE);
                }
            } else {
                u = 0;
            }
            if (falseStr.length > 0 && c == falseStr[k]) {
                if (++k == falseStr.length) {
                    return 0;
                }
            } else {
                k = 0;
            }
            if (!unixPromptReceived || this.inputStream.available() != 0) continue;
            return 2;
        }
        logger.info("Got it");
        return 1;
    }

    private void handleIAC(char c) throws IOException {
        if (c == '\u00ff') {
            char cmd = (char)this.inputStream.read();
            char opt = (char)this.inputStream.read();
            switch (opt) {
                case '\u0003': {
                    break;
                }
                case '\u0018': {
                    if (cmd == '\u00fd') {
                        this.print('\u00ff');
                        this.print('\u00fb');
                        this.print('\u0018');
                        this.print('\u00ff');
                        this.print('\u00fa');
                        this.print('\u0018');
                        this.print('\u0000');
                        this.print(TERM);
                        this.print('\u00ff');
                        this.print('\u00f0');
                        break;
                    }
                    if (cmd != '\u00fa') break;
                    while (this.inputStream.read() != 240) {
                    }
                    break;
                }
                default: {
                    if (cmd != '\u00fd') break;
                    this.print('\u00ff');
                    this.print('\u00fc');
                    this.print(opt);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

