/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.v1_1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClubMember
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String organizationId;
    @Deprecated
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String restaurantId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String memberId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String phone;
    public Set<String> clubIds = new LinkedHashSet<String>();

    public ClubMember(String organizationId, String memberId, String phone, Set<String> clubIds) {
        this.organizationId = organizationId;
        this.memberId = memberId;
        this.phone = phone;
        this.clubIds = clubIds;
        this.restaurantId = organizationId;
    }

    public ClubMember() {
    }

    public ClubMember clone() {
        return new ClubMember(this.organizationId, this.memberId, this.phone, (Set<String>)(this.clubIds != null ? new LinkedHashSet<String>(this.clubIds) : null));
    }

    public static List<ClubMember> clone(List<ClubMember> clubMembers) {
        if (clubMembers == null) {
            return null;
        }
        LinkedList<ClubMember> cloned = new LinkedList<ClubMember>();
        for (ClubMember clubMember : clubMembers) {
            cloned.add(clubMember != null ? clubMember.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClubMember that = (ClubMember)o;
        if (this.clubIds != null ? !this.clubIds.equals(that.clubIds) : that.clubIds != null) {
            return false;
        }
        if (this.memberId != null ? !this.memberId.equals(that.memberId) : that.memberId != null) {
            return false;
        }
        if (this.organizationId != null ? !this.organizationId.equals(that.organizationId) : that.organizationId != null) {
            return false;
        }
        if (this.phone != null ? !this.phone.equals(that.phone) : that.phone != null) {
            return false;
        }
        return !(this.restaurantId != null ? !this.restaurantId.equals(that.restaurantId) : that.restaurantId != null);
    }

    public int hashCode() {
        int result2 = this.organizationId != null ? this.organizationId.hashCode() : 0;
        result2 = 31 * result2 + (this.restaurantId != null ? this.restaurantId.hashCode() : 0);
        result2 = 31 * result2 + (this.memberId != null ? this.memberId.hashCode() : 0);
        result2 = 31 * result2 + (this.phone != null ? this.phone.hashCode() : 0);
        result2 = 31 * result2 + (this.clubIds != null ? this.clubIds.hashCode() : 0);
        return result2;
    }
}

