/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.v1_1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String PLATFORM_ANDROID = "android";
    public static final String PLATFORM_IOS = "ios";
    public static final Set<String> ALL_PLATFORMS = new HashSet<String>(Arrays.asList("android", "ios"));
    public static final String APP_TYPE_CLIENT = "client";
    public static final String APP_TYPE_EMPLOYEE = "employee";
    public static final Set<String> ALL_APP_TYPES = new HashSet<String>(Arrays.asList("client", "employee"));
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String platform;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String version;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String link;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String state = "operational";

    public AppInfo(String type, String platform, String id, String version, String link, String state) {
        this.type = type;
        this.platform = platform;
        this.id = id;
        this.version = version;
        this.link = link;
        this.state = state;
    }

    public AppInfo() {
    }

    public Object clone() {
        return new AppInfo(this.type, this.platform, this.id, this.version, this.link, this.state);
    }

    public static List<AppInfo> clone(List<AppInfo> apps) {
        if (apps == null) {
            return null;
        }
        LinkedList<AppInfo> cloned = new LinkedList<AppInfo>();
        for (AppInfo app : apps) {
            cloned.add(app != null ? (AppInfo)app.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppInfo appInfo = (AppInfo)o;
        return Objects.equals(this.type, appInfo.type) && Objects.equals(this.platform, appInfo.platform) && Objects.equals(this.id, appInfo.id) && Objects.equals(this.version, appInfo.version) && Objects.equals(this.link, appInfo.link) && Objects.equals(this.state, appInfo.state);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.platform, this.id, this.version, this.link, this.state);
    }
}

