/*
 * Decompiled with CFR 0.152.
 */
package com.genorder.resources;

import com.genorder.bean.Address;
import com.genorder.bean.OrderContact;
import com.genorder.bean.OrderItem;
import com.genorder.bean.OrderLog;
import com.genorder.bean.OrderRestaurant;
import com.genorder.bean.OrderSource;
import com.genorder.bean.OrderStatus;
import com.genorder.bean.Payment;
import com.genorder.bean.PaymentCreditCardDets;
import com.genorder.bean.RestPosParams;
import com.genorder.resources.GetOrderDetailts;
import com.toorder.bean.ToOrderItem;
import com.toorder.bean.ToOrderOrder;
import com.toorder.resources.DBConnector;
import com.toorder.resources.ToOrderFormatUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class GetToOrderDetailts
implements GetOrderDetailts<ToOrderOrder> {
    int count = 0;

    public String getOrderId(ToOrderOrder tord) {
        String order_id = tord.getToorder_id();
        return order_id;
    }

    @Override
    public Address getOrderAddress(ToOrderOrder tord) {
        String city = "TAW";
        String neightbourhood = "";
        String street = "";
        String hous_num = "";
        String entrance = "";
        String floor = "";
        String appartment = "";
        String addr_comment = "";
        Double gps_geo_lat = 0.0;
        Double gps_geo_lng = 0.0;
        if (!tord.getToord_header().getOrderAddressCity().equals("TAW")) {
            city = ToOrderFormatUtils.frmMSMStoUTFString(tord.getToord_header().getOrderAddressCity());
            neightbourhood = "";
            street = ToOrderFormatUtils.frmMSMStoUTFString(tord.getToord_header().getOrderAddressStreet());
            hous_num = ToOrderFormatUtils.frmMSMStoUTFString(tord.getToord_header().getOrderAddressHouse());
            entrance = ToOrderFormatUtils.frmMSMStoUTFString(tord.getToord_header().getOrderAddressEntrance());
            floor = ToOrderFormatUtils.frmMSMStoUTFString(tord.getToord_header().getOrderAddressFloor());
            appartment = ToOrderFormatUtils.frmString(tord.getToord_header().getOrderAddressFlat());
            addr_comment = ToOrderFormatUtils.frmMSMStoUTFString(tord.getToord_header().getOrderAddressComment());
            gps_geo_lat = 0.0;
            gps_geo_lng = 0.0;
        }
        return new Address(city, neightbourhood, street, hous_num, entrance, floor, appartment, addr_comment, gps_geo_lat, gps_geo_lng);
    }

    @Override
    public Date getOrderDateDeliveryTime(ToOrderOrder tord) {
        SimpleDateFormat dt_format = new SimpleDateFormat("dd/MM/yy");
        SimpleDateFormat time_format = new SimpleDateFormat("dd/MM/yy HH:mm");
        String dlv_time = tord.getToord_header().getOrderDestDate().replace(".", "/") + " " + tord.getToord_header().getOrderDestTime();
        Date order_dlv_time = new Date();
        String dtstr = dt_format.format(order_dlv_time);
        try {
            order_dlv_time = time_format.parse(dlv_time);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return order_dlv_time;
    }

    @Override
    public List<OrderContact> getOrderContacts(ToOrderOrder tord) {
        String contact_firstname = ToOrderFormatUtils.frmMSMStoUTFString(tord.getToord_header().getCustName());
        String contact_lastname = "";
        String contact_phone = ToOrderFormatUtils.frmPhone(tord.getToord_header().getCustPhoneNumber());
        String contact_cellphone = ToOrderFormatUtils.frmPhone(tord.getToord_header().getOrderCustomerPhoneNum());
        String contact_email = ToOrderFormatUtils.frmString(tord.getToord_header().getOrderCustomerEmail());
        String contact_fax = ToOrderFormatUtils.frmPhone(tord.getToord_header().getOrderCustomerFaxNumber());
        String contact_id = "";
        OrderContact oc = new OrderContact(contact_firstname, contact_lastname, contact_phone, contact_cellphone, contact_email, contact_fax, contact_id);
        LinkedList<OrderContact> ord_contact_list = new LinkedList<OrderContact>();
        ord_contact_list.add(oc);
        return ord_contact_list;
    }

    @Override
    public List<OrderItem> getOrderItems(ToOrderOrder tord) {
        LinkedList<OrderItem> gen_order_items = new LinkedList<OrderItem>();
        int item_poz = 0;
        for (ToOrderItem toorditm : tord.getToord_items()) {
            String itemLvl = ToOrderFormatUtils.frmString(toorditm.getItemLevel());
            String itemPosID = ToOrderFormatUtils.frmString(toorditm.getItemPOSCode());
            String itemID = ToOrderFormatUtils.frmString(toorditm.getItemPOSCode());
            String itemName = toorditm.getItemName();
            itemName = ToOrderFormatUtils.frmMSMStoUTFString(itemName);
            String itemPrice = toorditm.getItemPrice();
            String itemComment = "";
            if (itemID.contains("-C")) {
                itemComment = ToOrderFormatUtils.frmMSMStoUTFString(toorditm.getItemName());
                ((OrderItem)gen_order_items.get(item_poz - 1)).setItem_comment(itemComment);
                continue;
            }
            String itemQty = toorditm.getItemQty();
            String itemDiscount = "0.00";
            String itemTotal = "0.00";
            OrderItem gen_order_item = new OrderItem(++item_poz, Integer.valueOf(itemLvl), "", itemID, itemPosID, itemName, itemPrice, itemQty, itemDiscount, itemTotal, itemComment);
            gen_order_items.add(gen_order_item);
        }
        return gen_order_items;
    }

    @Override
    public OrderLog getOrderLog(ToOrderOrder tord) {
        return new OrderLog();
    }

    @Override
    public OrderRestaurant getOrderRestaurant(ToOrderOrder tord) throws Exception {
        String rest_source_id = "";
        String rest_local_id = "";
        return new OrderRestaurant(rest_source_id, rest_local_id, rest_source_id);
    }

    @Override
    public String getToOrderRestCode(String SourceRestCod) throws Exception {
        String resp = "";
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        resp = dbc.execute("W $G(^[$$^W3MAIN]W3SOR2M(\"" + SourceRestCod + "\")) ", global_map);
        if (resp.equals("[]")) {
            throw new Exception("Restaurant not connected to POS DB");
        }
        return resp;
    }

    @Override
    public OrderSource getOrderSource(ToOrderOrder tord) {
        String ord_src = tord.getToord_header().getOrderSource();
        if (ord_src == "") {
            return new OrderSource(15, "Torder", tord.getToorder_id());
        }
        return new OrderSource(Integer.valueOf(ord_src), "", tord.getToorder_id());
    }

    @Override
    public OrderStatus getOrderStatus(ToOrderOrder tord) {
        return new OrderStatus(1, "", "", "", "");
    }

    @Override
    public List<Payment> getOrderPayment(ToOrderOrder tord) {
        LinkedList<Payment> gen_order_payment = new LinkedList<Payment>();
        String ccardlst = tord.getToord_header().getOrderCreditCardNumber();
        String cc_exp = "";
        String cc_cvv = "";
        String cc_owner_id = "";
        String cc_enc_owner_id = "";
        String amount = "";
        String[] cc_exp_arr = tord.getToord_header().getOrderCreditCardValidity().split(";");
        String[] cc_cvv_arr = tord.getToord_header().getOrderCreditCardCVV().split(";");
        String[] cc_owner_id_arr = tord.getToord_header().getOrderCreditOwnerID().split("\\^");
        String[] amount_arr = tord.getToord_header().getOrderCreditCardSum().split(";");
        Double order_total = 0.0;
        order_total = Double.valueOf(tord.getToord_header().getOrderTotal());
        Double credit_total = 0.0;
        for (String enccard : ccardlst.split("\\^")) {
            if (enccard.equals("")) break;
            Payment gen_order_paytrn = new Payment();
            String cc_card_type = ToOrderFormatUtils.frmString("");
            String cc_phone = tord.getToord_header().getCustPhoneNumber();
            String order_id = tord.getToorder_id();
            String order_time = tord.getToord_header().getOrderDestTime();
            String order_date = tord.getToord_header().getOrderDestDate();
            String cc_number = "";
            cc_number = tord.getToord_header().msmDecr(cc_phone, enccard, order_date, order_time, order_id);
            cc_number = ToOrderFormatUtils.frmString(cc_number);
            cc_exp = GetToOrderDetailts.is_element_exists(cc_exp_arr, this.count) != false ? cc_exp_arr[this.count] : "";
            cc_cvv = GetToOrderDetailts.is_element_exists(cc_cvv_arr, this.count) != false ? cc_cvv_arr[this.count] : "";
            cc_enc_owner_id = GetToOrderDetailts.is_element_exists(cc_owner_id_arr, this.count) != false ? cc_owner_id_arr[this.count] : "";
            cc_owner_id = ToOrderFormatUtils.frmString(tord.getToord_header().msmDecr(cc_phone, cc_enc_owner_id, order_date, order_time, order_id));
            String cc_owner_name = "";
            String cc_owner_phone = "";
            amount = GetToOrderDetailts.is_element_exists(amount_arr, this.count) != false ? amount_arr[this.count] : "";
            amount = amount != "" ? amount : String.valueOf(order_total);
            PaymentCreditCardDets gen_order_credit = new PaymentCreditCardDets(cc_card_type, cc_number, cc_exp, cc_cvv, cc_owner_name, cc_owner_id, cc_owner_phone);
            gen_order_paytrn.setAmount(amount);
            gen_order_paytrn.setPayment_id(3);
            gen_order_paytrn.setPayment_type("CreditCard");
            gen_order_paytrn.setPayment_card_dets(gen_order_credit);
            gen_order_payment.add(gen_order_paytrn);
            ++this.count;
            credit_total = credit_total + Double.valueOf(amount);
        }
        if (order_total > credit_total) {
            Payment gen_order_paytrn = new Payment();
            amount = String.valueOf(order_total - credit_total);
            gen_order_paytrn.setAmount(amount);
            gen_order_paytrn.setPayment_id(1);
            gen_order_paytrn.setPayment_type("Cash");
            gen_order_payment.add(gen_order_paytrn);
        }
        return gen_order_payment;
    }

    public static Boolean is_element_exists(String[] data, int index) {
        try {
            String element = data[index];
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public String getOrderDeliveryFee(ToOrderOrder tord) {
        String dlvfee = tord.getToord_header().getOrderDeliveryFeeNIS();
        return dlvfee;
    }

    @Override
    public String getOrderDiscount(ToOrderOrder tord) {
        String order_discount = tord.getToord_header().getOrderDiscounNIS();
        return order_discount;
    }

    @Override
    public String getOrderTotal(ToOrderOrder tord) {
        String total = tord.getToord_header().getOrderTotal();
        return total;
    }

    @Override
    public String getOrderComment(ToOrderOrder tord) {
        String order_comment = ToOrderFormatUtils.frmMSMStoUTFString(tord.getToord_header().getOrderComment());
        return order_comment;
    }

    @Override
    public RestPosParams getRestPosParams(ToOrderOrder tord) {
        return new RestPosParams();
    }

    @Override
    public int getNumOfDinners(ToOrderOrder tord) {
        int takeoutPack = tord.getToord_header().getOrderNumOfDinners() == "" ? 0 : Integer.valueOf(tord.getToord_header().getOrderNumOfDinners());
        return takeoutPack;
    }

    @Override
    public String getOrderId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

