/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import com.enterprisedt.net.ftp.test.TestProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestTransfer
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestTransfer.java,v 1.17 2012/11/06 04:12:13 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestTransfer;

    protected String getLogName() {
        return "TestTransfer.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferBinary() throws Exception {
        log.info("testTransferBinary()");
        try {
            this.connect();
            this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
            this.ftp.chdir(this.testdir);
            this.ftp.setType(FTPTransferType.BINARY);
            String filename = this.generateRandomFilename();
            this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
            this.ftp.get(this.localDataDir + filename, filename);
            this.ftp.delete(filename);
            try {
                this.ftp.modtime(filename);
                TestTransfer.fail((String)(filename + " should not be found"));
            }
            catch (IOException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            catch (FTPException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            this.assertIdentical(this.localDataDir + this.localBinaryFile, this.localDataDir + filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            this.ftp.quit();
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferUnique() throws Exception {
        log.info("testTransferUnique()");
        try {
            this.connect();
            this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
            this.ftp.chdir(this.testdir);
            this.ftp.setType(FTPTransferType.BINARY);
            String filename = this.ftp.put(this.localDataDir + this.localBinaryFile, null);
            log.info("Put file to '" + filename + "'");
            this.ftp.get(this.localDataDir + filename, filename);
            this.ftp.delete(filename);
            try {
                this.ftp.modtime(filename);
                TestTransfer.fail((String)(filename + " should not be found"));
            }
            catch (IOException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            catch (FTPException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            this.assertIdentical(this.localDataDir + this.localBinaryFile, this.localDataDir + filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            this.ftp.quit();
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoLocalFilename() throws Exception {
        log.info("testNoLocalFilename()");
        try {
            this.connect();
            this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
            this.ftp.chdir(this.testdir);
            this.ftp.setType(FTPTransferType.BINARY);
            String filename = this.generateRandomFilename();
            this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
            log.info("Put file to '" + filename + "'");
            this.ftp.get(this.localDataDir, filename);
            this.ftp.delete(filename);
            try {
                this.ftp.modtime(filename);
                TestTransfer.fail((String)(filename + " should not be found"));
            }
            catch (IOException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            catch (FTPException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            this.assertIdentical(this.localDataDir + this.localBinaryFile, this.localDataDir + filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            this.ftp.quit();
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferText() throws Exception {
        log.info("testTransferText()");
        try {
            this.connect();
            this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
            this.ftp.chdir(this.testdir);
            this.ftp.setType(FTPTransferType.ASCII);
            String filename = this.generateRandomFilename();
            this.ftp.put(this.localDataDir + this.localTextFile, filename);
            this.ftp.get(this.localDataDir + filename, filename);
            this.ftp.delete(filename);
            try {
                this.ftp.modtime(filename);
                TestTransfer.fail((String)(filename + " should not be found"));
            }
            catch (IOException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            catch (FTPException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            this.assertIdentical(this.localDataDir + this.localTextFile, this.localDataDir + filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            this.ftp.quit();
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferUnixText() throws Exception {
        log.info("testTransferUnixText()");
        try {
            this.connect();
            this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
            this.ftp.chdir(this.testdir);
            this.ftp.setType(FTPTransferType.ASCII);
            String filename = this.generateRandomFilename();
            this.ftp.put(this.localDataDir + this.localUnixTextFile, filename);
            this.ftp.get(this.localDataDir + filename, filename);
            this.assertIdentical(this.localDataDir + this.localTextFile, this.localDataDir + filename);
            this.ftp.delete(filename);
            try {
                this.ftp.modtime(filename);
                TestTransfer.fail((String)(filename + " should not be found"));
            }
            catch (IOException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            catch (FTPException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            File local = new File(this.localDataDir + filename);
            local.delete();
            this.ftp.quit();
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBytes() throws Exception {
        log.info("testGetBytes()");
        try {
            this.connect();
            this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
            this.ftp.chdir(this.testdir);
            this.ftp.setType(FTPTransferType.BINARY);
            String filename1 = this.generateRandomFilename();
            this.ftp.get(this.localDataDir + filename1, this.remoteBinaryFile);
            File file1 = new File(this.localDataDir + filename1);
            long len = file1.length();
            byte[] result2 = this.ftp.get(this.remoteBinaryFile);
            TestTransfer.assertTrue(((long)result2.length == len ? 1 : 0) != 0);
            String filename2 = this.generateRandomFilename();
            this.ftp.put(result2, filename2);
            this.ftp.get(this.localDataDir + filename2, filename2);
            this.ftp.delete(filename2);
            File file2 = new File(this.localDataDir + filename2);
            this.assertIdentical(file1, file2);
            file1.delete();
            file2.delete();
            this.ftp.quit();
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferStream() throws Exception {
        log.info("testTransferStream()");
        try {
            this.connect();
            this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
            this.ftp.chdir(this.testdir);
            this.ftp.setType(FTPTransferType.BINARY);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.ftp.get(out, this.remoteBinaryFile);
            byte[] result1 = out.toByteArray();
            String filename = this.generateRandomFilename();
            this.ftp.put(new ByteArrayInputStream(result1), filename);
            byte[] result2 = this.ftp.get(filename);
            this.ftp.delete(filename);
            this.assertIdentical(result1, result2);
            this.ftp.quit();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPutAppend() throws Exception {
        log.info("testPutAppend()");
        try {
            this.connect();
            this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
            this.ftp.chdir(this.testdir);
            this.ftp.setType(FTPTransferType.BINARY);
            String filename = this.generateRandomFilename();
            this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
            int count = 1;
            this.ftp.put(this.localDataDir + this.localBinaryFile, filename, true);
            this.ftp.get(this.localDataDir + filename, filename);
            this.ftp.delete(filename);
            File file1 = new File(this.localDataDir + this.localBinaryFile);
            File file2 = new File(this.localDataDir + filename);
            TestTransfer.assertTrue((file1.length() * (long)(++count) == file2.length() ? 1 : 0) != 0);
            log.info(this.localBinaryFile + " length=" + file1.length() + ", " + filename + " length=" + file2.length());
            file2.delete();
            this.ftp.quit();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOverwrite() throws Exception {
        log.info("testOverwrite()");
        try {
            this.connect();
            this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
            this.ftp.chdir(this.testdir);
            this.ftp.setType(FTPTransferType.BINARY);
            String filename = this.generateRandomFilename();
            this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
            this.ftp.put(this.localDataDir + this.localBinaryFile, filename, true);
            File file1 = new File(this.localDataDir + this.localBinaryFile);
            TestTransfer.assertTrue((file1.length() * 2L == this.ftp.size(filename) ? 1 : 0) != 0);
            this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
            this.ftp.get(this.localDataDir + filename, filename);
            this.ftp.delete(filename);
            File file2 = new File(this.localDataDir + filename);
            TestTransfer.assertTrue((file1.length() == file2.length() ? 1 : 0) != 0);
            log.info(this.localBinaryFile + " length=" + file1.length() + ", " + filename + " length=" + file2.length());
            file2.delete();
            this.ftp.quit();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferEmpty() throws Exception {
        log.info("testTransferEmpty()");
        try {
            this.connect();
            this.ftp.chdir(this.testdir);
            this.ftp.get(this.localDataDir + this.remoteEmptyFile, this.remoteEmptyFile);
            File empty = new File(this.localDataDir + this.remoteEmptyFile);
            TestTransfer.assertTrue((boolean)empty.exists());
            TestTransfer.assertTrue((empty.length() == 0L ? 1 : 0) != 0);
            empty.delete();
            this.ftp.put(this.localDataDir + this.localEmptyFile, this.localEmptyFile);
            String filename = this.generateRandomFilename();
            this.ftp.get(this.localDataDir + filename, this.localEmptyFile);
            empty = new File(this.localDataDir + filename);
            TestTransfer.assertTrue((boolean)empty.exists());
            TestTransfer.assertTrue((empty.length() == 0L ? 1 : 0) != 0);
            empty.delete();
            this.ftp.delete(this.localEmptyFile);
            this.ftp.quit();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferNonExistent() throws Exception {
        log.info("testTransferNonExistent()");
        try {
            this.connect();
            this.ftp.chdir(this.testdir);
            String filename = this.generateRandomFilename();
            log.info("Getting non-existent file: " + filename);
            try {
                this.ftp.get(this.localDataDir + filename, filename);
                TestTransfer.fail((String)(filename + " should not be found"));
            }
            catch (IOException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            catch (FTPException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            File file = new File(this.localDataDir + filename);
            TestTransfer.assertFalse((boolean)file.exists());
            filename = this.generateRandomFilename();
            try {
                this.ftp.put(this.localDataDir + filename, filename);
                TestTransfer.fail((String)(filename + " should not be found"));
            }
            catch (FileNotFoundException ex) {
                log.info("Expected exception: " + ex.getMessage());
            }
            this.ftp.quit();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestTransfer == null ? (class$com$enterprisedt$net$ftp$test$TestTransfer = TestTransfer.class$("com.enterprisedt.net.ftp.test.TestTransfer")) : class$com$enterprisedt$net$ftp$test$TestTransfer);
    }

    public static void main(String[] args2) {
        TestRunner.run((Test)TestTransfer.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

