/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.FileAppender;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.debug.StandardOutputAppender;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;

public class FileParserTest {
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$FileParserTest;

    public static void main(String[] args2) throws Exception {
        if (args2.length < 2) {
            FileParserTest.usage();
        }
        Logger log = Logger.getLogger(class$com$enterprisedt$net$ftp$test$FileParserTest == null ? (class$com$enterprisedt$net$ftp$test$FileParserTest = FileParserTest.class$("com.enterprisedt.net.ftp.test.FileParserTest")) : class$com$enterprisedt$net$ftp$test$FileParserTest);
        Logger.setLevel(Level.ALL);
        Logger.addAppender(new FileAppender("parser.log"));
        Logger.addAppender(new StandardOutputAppender());
        String type = args2[0];
        String filename = args2[1];
        String locale = null;
        if (args2.length == 3) {
            locale = args2[2];
        }
        FTPFileParser parser = null;
        try {
            Class<?> clazz = Class.forName(type);
            parser = (FTPFileParser)clazz.newInstance();
        }
        catch (Throwable t) {
            FileParserTest.usage();
        }
        log.debug("Type=" + type);
        Vector<String> lines = new Vector<String>();
        BufferedReader reader = null;
        String line = null;
        try {
            FTPFileFactory ff = new FTPFileFactory(parser);
            if (locale != null) {
                System.out.println("Setting locale to " + locale);
                Locale l = new Locale(locale);
                Locale[] locales = new Locale[]{l, Locale.ENGLISH};
                ff.setLocales(locales);
            } else {
                Locale[] locales = new Locale[]{Locale.ENGLISH};
                ff.setLocales(locales);
            }
            reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                lines.addElement(line);
                log.debug(line);
            }
            Object[] listings = new String[lines.size()];
            lines.copyInto(listings);
            ff.detectParser((String[])listings);
            FTPFile[] files2 = ff.parse((String[])listings);
            for (int i = 0; i < files2.length; ++i) {
                log.debug(files2[i].toString());
            }
        }
        catch (IOException ex) {
            System.out.println("Failed to read file: " + filename);
            ex.printStackTrace();
        }
        catch (ParseException ex) {
            System.out.println("Failed to parse line '" + line + "'");
            ex.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: FileParserTest parserclass filename [locale]");
        System.exit(-1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

