/*
 * Decompiled with CFR 0.152.
 */
package com.cav.mserver.tests;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class HttpMuxBenchmark {
    public static void main(String[] args2) {
        if (args2.length != 3) {
            System.err.println("Usage: java " + HttpMuxBenchmark.class.getName() + " url num_threads num_requests");
            System.exit(1);
        }
        String serverUrl = args2[0];
        int nThreads = Integer.parseInt(args2[1]);
        int nRequests = Integer.parseInt(args2[2]);
        for (int i = 0; i < nThreads; ++i) {
            new ClientThread(serverUrl, nRequests).start();
        }
    }

    private static class ClientThread
    extends Thread {
        int nRequests;
        String serverUrl;

        public ClientThread(String serverUrl, int nRequests) {
            this.serverUrl = serverUrl;
            this.nRequests = nRequests;
        }

        @Override
        public void run() {
            URL url = null;
            try {
                url = new URL(this.serverUrl);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return;
            }
            long start = System.currentTimeMillis();
            for (int i = 0; i < this.nRequests; ++i) {
                try {
                    InputStream is = url.openConnection().getInputStream();
                    while (is.read() != -1) {
                    }
                    is.close();
                    continue;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
            }
            long duration = System.currentTimeMillis() - start;
            System.out.println("Took " + duration + " mSecs");
        }
    }
}

