/*
 * Decompiled with CFR 0.152.
 */
package com.cav.mserver;

import com.cav.mserver.Config;
import com.cav.mserver.LoggingConfiguration;
import com.cav.mserver.MumpsTelnetSession;
import com.cav.mserver.MuxSession;
import com.cav.mserver.PoolableMumpsSessionFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class MumpsSessionPool {
    private static Logger logger = Logger.getLogger(MumpsSessionPool.class.getPackage().getName());
    private static ObjectPool pool;

    public static synchronized ObjectPool instance() {
        if (pool == null) {
            LoggingConfiguration.init();
            int maxActive = Config.getInt("pool.maxActive", 10);
            int maxWait = Config.getInt("pool.maxWaitSecs", 10) * 1000;
            int initIdle = Config.getInt("pool.initIdle", 5);
            int maxIdle = Config.getInt("pool.maxIdle", 5);
            logger.info("Creating pool: maxActive=" + maxActive + ", initIdle=" + initIdle + ", maxWait=" + maxWait);
            Class mumpsSessionClass = Config.getString("telnet.host") == null ? MuxSession.class : MumpsTelnetSession.class;
            pool = new GenericObjectPool((PoolableObjectFactory)new PoolableMumpsSessionFactory(mumpsSessionClass), maxActive, 1, (long)maxWait, maxIdle, false, true);
            ((GenericObjectPool)pool).setTestWhileIdle(true);
            int refreshTime = Config.getInt("pool.refreshTime", 90) * 1000;
            ((GenericObjectPool)pool).setTimeBetweenEvictionRunsMillis((long)refreshTime);
            logger.info("Initializing idle sessions");
            Object[] idleObjs = new Object[initIdle];
            try {
                int i;
                for (i = 0; i < initIdle; ++i) {
                    idleObjs[i] = pool.borrowObject();
                }
                for (i = 0; i < initIdle; ++i) {
                    pool.returnObject(idleObjs[i]);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error borrowing or returning initial idle sessions", e);
            }
            logger.info("Idle init done");
        }
        return pool;
    }
}

