/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.DateFormats;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JwtMap
implements Map<String, Object> {
    private final Map<String, Object> map = new LinkedHashMap<String, Object>();

    public JwtMap() {
    }

    public JwtMap(Map<String, ?> map) {
        this();
        Assert.notNull(map, "Map argument cannot be null.");
        this.putAll((Map<? extends String, ?>)map);
    }

    protected String getString(String name) {
        Object v = this.get(name);
        return v != null ? String.valueOf(v) : null;
    }

    protected static Date toDate(Object v, String name) {
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        if (v instanceof Calendar) {
            return ((Calendar)v).getTime();
        }
        if (v instanceof Number) {
            long millis = ((Number)v).longValue();
            return new Date(millis);
        }
        if (v instanceof String) {
            return JwtMap.parseIso8601Date((String)v, name);
        }
        throw new IllegalStateException("Cannot create Date from '" + name + "' value '" + v + "'.");
    }

    private static Date parseIso8601Date(String s, String name) throws IllegalArgumentException {
        try {
            return DateFormats.parseIso8601Date(s);
        }
        catch (ParseException e) {
            String msg = "'" + name + "' value does not appear to be ISO-8601-formatted: " + s;
            throw new IllegalArgumentException(msg, e);
        }
    }

    protected static Date toSpecDate(Object v, String name) {
        if (v == null) {
            return null;
        }
        if (v instanceof Number) {
            long seconds = ((Number)v).longValue();
            v = seconds * 1000L;
        } else if (v instanceof String) {
            try {
                long seconds = Long.parseLong((String)v);
                v = seconds * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return JwtMap.toDate(v, name);
    }

    protected void setValue(String name, Object v) {
        if (v == null) {
            this.map.remove(name);
        } else {
            this.map.put(name, v);
        }
    }

    @Deprecated
    protected void setDate(String name, Date d) {
        if (d == null) {
            this.map.remove(name);
        } else {
            long seconds = d.getTime() / 1000L;
            this.map.put(name, seconds);
        }
    }

    protected Object setDateAsSeconds(String name, Date d) {
        if (d == null) {
            return this.map.remove(name);
        }
        long seconds = d.getTime() / 1000L;
        return this.map.put(name, seconds);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    @Override
    public Object get(Object o) {
        return this.map.get(o);
    }

    @Override
    public Object put(String s, Object o) {
        if (o == null) {
            return this.map.remove(s);
        }
        return this.map.put(s, o);
    }

    @Override
    public Object remove(Object o) {
        return this.map.remove(o);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (m == null) {
            return;
        }
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }
}

