/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.reservations.log;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.openrest.v1_1.User;
import com.wix.restaurants.reservations.log.CommentLogEntry;
import com.wix.restaurants.reservations.log.StatusLogEntry;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CommentLogEntry.class, name="comment"), @JsonSubTypes.Type(value=StatusLogEntry.class, name="status")})
public abstract class LogEntry
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Date timestamp;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public User user;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String actingAs;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String comment;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> properties;

    public LogEntry() {
    }

    public LogEntry(Date timestamp, User user, String actingAs, String comment, Map<String, String> properties) {
        this.timestamp = timestamp;
        this.user = user;
        this.actingAs = actingAs;
        this.comment = comment;
        this.properties = properties;
    }

    public LogEntry clone() {
        return this.cloneImpl();
    }

    protected abstract LogEntry cloneImpl();

    public static List<LogEntry> clone(List<LogEntry> log) {
        if (log == null) {
            return null;
        }
        LinkedList<LogEntry> cloned = new LinkedList<LogEntry>();
        for (LogEntry logEntry : log) {
            cloned.add(logEntry != null ? logEntry.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        LogEntry logEntry = (LogEntry)o;
        if (this.timestamp != null ? !this.timestamp.equals(logEntry.timestamp) : logEntry.timestamp != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(logEntry.user) : logEntry.user != null) {
            return false;
        }
        if (this.actingAs != null ? !this.actingAs.equals(logEntry.actingAs) : logEntry.actingAs != null) {
            return false;
        }
        if (this.comment != null ? !this.comment.equals(logEntry.comment) : logEntry.comment != null) {
            return false;
        }
        return this.properties != null ? this.properties.equals(logEntry.properties) : logEntry.properties == null;
    }

    public int hashCode() {
        int result2 = this.timestamp != null ? this.timestamp.hashCode() : 0;
        result2 = 31 * result2 + (this.user != null ? this.user.hashCode() : 0);
        result2 = 31 * result2 + (this.actingAs != null ? this.actingAs.hashCode() : 0);
        result2 = 31 * result2 + (this.comment != null ? this.comment.hashCode() : 0);
        result2 = 31 * result2 + (this.properties != null ? this.properties.hashCode() : 0);
        return result2;
    }
}

