/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.payments;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.wix.restaurants.payments.Payment;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MultipassPayment
extends Payment {
    public static final String TYPE = "il.co.multipass";
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String number;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String pin;

    public MultipassPayment() {
    }

    public MultipassPayment(Integer amount, Map<String, String> externalIds, String number, String pin) {
        super(amount, externalIds);
        this.number = number;
        this.pin = pin;
    }

    @Override
    public MultipassPayment clone() {
        return this.cloneImpl();
    }

    @Override
    protected MultipassPayment cloneImpl() {
        return new MultipassPayment(this.amount, this.externalIds != null ? new LinkedHashMap<String, String>(this.externalIds) : null, this.number, this.pin);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultipassPayment that = (MultipassPayment)o;
        if (this.number != null ? !this.number.equals(that.number) : that.number != null) {
            return false;
        }
        return this.pin != null ? this.pin.equals(that.pin) : that.pin == null;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.number != null ? this.number.hashCode() : 0);
        result2 = 31 * result2 + (this.pin != null ? this.pin.hashCode() : 0);
        return result2;
    }
}

