/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.i18n;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.wix.restaurants.i18n.Locale;
import com.wix.restaurants.i18n.LocalizedString;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LocalizedStringDeserializer
extends StdDeserializer<LocalizedString> {
    public LocalizedStringDeserializer() {
        this((Class<LocalizedString>)null);
    }

    public LocalizedStringDeserializer(Class<LocalizedString> t) {
        super(t);
    }

    @Override
    public LocalizedString deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        LinkedHashMap<Locale, String> localized = new LinkedHashMap<Locale, String>();
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        Iterator<Map.Entry<String, JsonNode>> it = node.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> entry = it.next();
            localized.put(new Locale(entry.getKey()), entry.getValue().textValue());
        }
        return new LocalizedString(localized);
    }
}

