/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.availability;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WeeklyTimeWindow
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int HOUR = 60;
    public static final int DAY = 1440;
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1440;
    public static final int TUESDAY = 2880;
    public static final int WEDNESDAY = 4320;
    public static final int THURSDAY = 5760;
    public static final int FRIDAY = 7200;
    public static final int SATURDAY = 8640;
    public static final int MINUTES_IN_WEEK = 10080;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer minuteOfWeek;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer durationMins;

    public WeeklyTimeWindow() {
    }

    public WeeklyTimeWindow(Integer minuteOfWeek, Integer durationMins) {
        this.minuteOfWeek = minuteOfWeek;
        this.durationMins = durationMins;
    }

    public WeeklyTimeWindow clone() {
        return new WeeklyTimeWindow(this.minuteOfWeek, this.durationMins);
    }

    public static List<WeeklyTimeWindow> clone(List<WeeklyTimeWindow> windows) {
        if (windows == null) {
            return null;
        }
        ArrayList<WeeklyTimeWindow> cloned = new ArrayList<WeeklyTimeWindow>(windows.size());
        for (WeeklyTimeWindow window : windows) {
            cloned.add(window != null ? window.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeeklyTimeWindow that = (WeeklyTimeWindow)o;
        if (this.minuteOfWeek != null ? !this.minuteOfWeek.equals(that.minuteOfWeek) : that.minuteOfWeek != null) {
            return false;
        }
        return this.durationMins != null ? this.durationMins.equals(that.durationMins) : that.durationMins == null;
    }

    public int hashCode() {
        int result2 = this.minuteOfWeek != null ? this.minuteOfWeek.hashCode() : 0;
        result2 = 31 * result2 + (this.durationMins != null ? this.durationMins.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "WeeklyTimeWindow{minuteOfWeek=" + this.minuteOfWeek + ", durationMins=" + this.durationMins + '}';
    }

    public int endMinuteOfWeek() {
        return this.minuteOfWeek + this.durationMins;
    }
}

