/*
 * Decompiled with CFR 0.152.
 */
package com.toorder.bean;

import com.genorder.bean.GeneralOrder;
import com.genorder.bean.OrderContact;
import com.genorder.bean.Payment;
import com.toorder.bean.ToOrderHeaderShema;
import com.toorder.resources.ToOrderFormatUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

public class ToOrderHeader {
    private String custPhoneNumber = "";
    private String custName = "";
    private String orderAddressStreet = "";
    private String orderReceiveTime = "";
    private String orderDestDate = "";
    private String orderDestTime = "";
    private String orderAddressComment = "";
    private String orderDiscounNIS = "";
    private String orderDeliveryFeeNIS = "";
    private String orderTotal = "";
    private String orderAddressFloor = "";
    private String orderAddressFlat = "";
    private String orderAddressHouse = "";
    private String orderAddressEntrance = "";
    private String orderClientCreditTotal = "";
    private String orderCollectorID = "";
    private String orderTypeOfPayment = "";
    private String orderDeliveryFeeInPersent = "";
    private String orderNumOfDinners = "";
    private String orderCustomerNumber = "";
    private String orderNumber = "";
    private String orderAddressCity = "";
    private String orderMobilePhoneNumber = "";
    private String orderMinimumPrice = "";
    private String orderComment = "";
    private String orderPriceCancelDeliveryFee = "";
    private String orderPriceCanceldeliveryFee = "";
    private String orderDiscountInPercent = "";
    private String orderPaymentCibusCompanyId = "";
    private String orderPaymentCibusCardNum = "";
    private String orderCustomerCompanyName = "";
    private String orderCreditCardNumber = "";
    private String orderCreditCardValidity = "";
    private String orderCustomerID = "";
    private String orderSource = "";
    private String orderPaymentTenbisCompanyID = "";
    private String orderPaymentTenbisCardNum = "";
    private String orderPaymentTenbisSum = "";
    private String orderCustomerEmail = "";
    private String orderCustomerPostIndex = "";
    private String orderCustomerFaxNumber = "";
    private String orderCustomerPhoneNum = "";
    private String orderCustomerOrderId = "";
    private String orderCreditOwnerID = "";
    private String orderCreditCardCVV = "";
    private String orderCreditCardSum = "";
    private String orderPaymentCibusSum = "";
    private String orderGoodiesCard = "";
    private String orderGoodiesSum = "";

    public ToOrderHeader() {
    }

    public ToOrderHeader(GeneralOrder gen_ord) throws Exception {
        LinkedList<OrderContact> gen_order_contacts = new LinkedList<OrderContact>(gen_ord.getOrder_contact());
        this.custPhoneNumber = gen_ord.getTable_num() != null ? gen_ord.getTable_num() : ((OrderContact)gen_order_contacts.get(0)).getContact_cellular();
        this.custPhoneNumber = !"".equals(this.custPhoneNumber) ? this.custPhoneNumber : ((OrderContact)gen_order_contacts.get(0)).getContact_phone();
        this.custName = ToOrderFormatUtils.frmToMSMString(((OrderContact)gen_order_contacts.get(0)).getContact_lastname() + " " + ((OrderContact)gen_order_contacts.get(0)).getContact_firstname());
        this.orderAddressStreet = ToOrderFormatUtils.frmToMSMString(gen_ord.getAddress().getStreet());
        Date date_now = new Date();
        this.orderReceiveTime = ToOrderFormatUtils.frmDateTime(date_now, "dd.MM.yy") + " " + " " + ToOrderFormatUtils.frmDateTime(date_now, "HH:mm");
        this.orderDestDate = ToOrderFormatUtils.frmDateTime(gen_ord.getOrder_date_delivery(), "dd.MM.yy");
        this.orderDestTime = ToOrderFormatUtils.frmDateTime(gen_ord.getOrder_date_delivery(), "HH:mm");
        this.orderAddressComment = ToOrderFormatUtils.frmToMSMString(gen_ord.getAddress().getAddress_remark());
        this.orderDiscounNIS = ToOrderFormatUtils.frmString(gen_ord.getOrder_discount());
        this.orderDeliveryFeeNIS = ToOrderFormatUtils.frmString(gen_ord.getDelivery_fee());
        Double orderTotalWithOutTip = Double.valueOf(gen_ord.getOrder_total());
        if (gen_ord.getOrder_tip() != null) {
            Iterator<Payment> tip = Double.valueOf(gen_ord.getOrder_tip());
            orderTotalWithOutTip = orderTotalWithOutTip - (Double)((Object)tip);
        }
        this.orderTotal = ToOrderFormatUtils.frmString(String.valueOf(orderTotalWithOutTip));
        this.orderNumOfDinners = Integer.toString(gen_ord.getNum_of_dinners());
        this.orderAddressFloor = ToOrderFormatUtils.frmToMSMString(gen_ord.getAddress().getFloor_num());
        this.orderAddressFlat = ToOrderFormatUtils.frmToMSMString(gen_ord.getAddress().getAppartment());
        this.orderAddressHouse = ToOrderFormatUtils.frmToMSMString(gen_ord.getAddress().getHouse_number());
        this.orderAddressEntrance = ToOrderFormatUtils.frmToMSMString(gen_ord.getAddress().getEntrance());
        this.orderCollectorID = ToOrderFormatUtils.frmString(gen_ord.getCollector_id());
        this.orderTypeOfPayment = "";
        this.orderDeliveryFeeInPersent = gen_ord.getDelivery_fee();
        this.orderCustomerNumber = this.custPhoneNumber;
        this.orderAddressCity = ToOrderFormatUtils.frmToMSMString(gen_ord.getAddress().getCity());
        this.orderMobilePhoneNumber = ((OrderContact)gen_order_contacts.get(0)).getContact_cellular();
        this.orderMinimumPrice = "";
        this.orderComment = ToOrderFormatUtils.frmToMSMString(gen_ord.getOrder_remark());
        this.orderPriceCancelDeliveryFee = "";
        this.orderDiscountInPercent = "";
        this.orderPaymentCibusCompanyId = "";
        this.orderPaymentCibusCardNum = "";
        this.orderPaymentCibusSum = "";
        this.orderCustomerCompanyName = ToOrderFormatUtils.frmToMSMString(gen_ord.getCompany_name());
        this.orderCreditCardNumber = "";
        this.orderCreditCardValidity = "";
        for (Payment genord_pay : gen_ord.getPayments()) {
            if (genord_pay.getPayment_id() == 3) {
                if (null == genord_pay.getPayment_card_dets()) {
                    this.orderTypeOfPayment = "3";
                    continue;
                }
                if (!"".equals(this.orderCreditCardNumber)) {
                    this.orderCreditCardNumber = this.orderCreditCardNumber + "^";
                    this.orderCreditCardValidity = this.orderCreditCardValidity + ";";
                    this.orderCreditCardCVV = this.orderCreditCardCVV + ";";
                    this.orderCreditOwnerID = this.orderCreditOwnerID + "^";
                    this.orderCreditCardSum = this.orderCreditCardSum + ";";
                }
                String enccard = "";
                String enccustid = "";
                String custid = "";
                String ccard = genord_pay.getPayment_card_dets().getCc_number();
                String cctype = genord_pay.getPayment_card_dets().getCc_card_type();
                if (cctype.equals("visa")) {
                    // empty if block
                }
                cctype = "2";
                enccard = ccard != "" ? this.msmEncr(this.custPhoneNumber.replaceAll("\\D+", ""), ccard.replaceAll("\\D+", ""), this.orderDestDate, this.orderDestTime, gen_ord.getOrder_id()) : cctype;
                custid = genord_pay.getPayment_card_dets().getCc_owner_id().replaceAll("\\D+", "");
                if (custid.length() > 0) {
                    enccustid = this.msmEncr(this.custPhoneNumber.replaceAll("\\D+", ""), custid, this.orderDestDate, this.orderDestTime, gen_ord.getOrder_id());
                }
                this.orderCreditCardNumber = this.orderCreditCardNumber + enccard;
                this.orderCreditCardValidity = this.orderCreditCardValidity + genord_pay.getPayment_card_dets().getCc_exp().replace("/", "");
                this.orderCreditCardCVV = this.orderCreditCardCVV + genord_pay.getPayment_card_dets().getCc_cvv();
                this.orderCreditOwnerID = this.orderCreditOwnerID + enccustid;
                this.orderCreditCardSum = this.orderCreditCardSum + genord_pay.getAmount();
            }
            if (genord_pay.getPayment_id() == 1) {
                this.orderTypeOfPayment = "1";
                continue;
            }
            if (genord_pay.getPayment_id() == 4) {
                this.orderTypeOfPayment = "4";
                continue;
            }
            if (genord_pay.getPayment_id() == 6) {
                this.orderTypeOfPayment = "6";
                this.orderGoodiesSum = genord_pay.getAmount();
                continue;
            }
            if (genord_pay.getPayment_id() == 5) {
                this.orderTypeOfPayment = "5";
                this.orderPaymentCibusSum = genord_pay.getAmount();
                continue;
            }
            if (genord_pay.getPayment_id() == 7) {
                this.orderTypeOfPayment = "7";
                this.orderPaymentTenbisSum = genord_pay.getAmount();
                continue;
            }
            if (genord_pay.getPayment_id() == 12) {
                this.orderTypeOfPayment = "12";
                this.orderCreditCardSum = genord_pay.getAmount();
                continue;
            }
            if (genord_pay.getPayment_id() == 14) {
                this.orderClientCreditTotal = genord_pay.getAmount();
                this.orderTypeOfPayment = "14";
                continue;
            }
            if (genord_pay.getPayment_id() == 16) {
                this.orderClientCreditTotal = genord_pay.getAmount();
                this.orderTypeOfPayment = "16";
                continue;
            }
            if (this.orderTypeOfPayment != "") continue;
            this.orderTypeOfPayment = "3";
        }
        for (Payment genord_pay : gen_ord.getPayments()) {
            if (Integer.valueOf(this.orderTypeOfPayment) >= genord_pay.getPayment_id()) continue;
            this.orderTypeOfPayment = String.valueOf(genord_pay.getPayment_id());
        }
        this.orderCustomerID = ToOrderFormatUtils.frmString(((OrderContact)gen_order_contacts.get(0)).getContact_id());
        ToOrderFormatUtils.frmString(gen_ord.getOrder_source().getSource_order_id());
        this.orderNumber = ToOrderFormatUtils.frmString(gen_ord.getOrder_source().getSource_order_id());
        this.orderCustomerEmail = ToOrderFormatUtils.eng2Upper(((OrderContact)gen_order_contacts.get(0)).getContact_email());
        this.orderCustomerPostIndex = "";
        this.orderCustomerFaxNumber = ((OrderContact)gen_order_contacts.get(0)).getContact_fax();
        this.orderCustomerPhoneNum = ((OrderContact)gen_order_contacts.get(0)).getContact_phone();
        this.orderSource = ToOrderFormatUtils.frmToMSMString(String.valueOf(gen_ord.getOrder_source().getSource_id()));
        String source_order_id = gen_ord.getOrder_source().getSource_order_id();
        this.orderCustomerOrderId = ToOrderFormatUtils.frmToMSMString(source_order_id);
    }

    public ToOrderHeader(ToOrderHeaderShema tohdrshema) {
        ArrayList<String> headerDets = new ArrayList<String>(71);
        String[] hdrarr = tohdrshema.getHeader_record().split("~");
        for (int i = 0; i < 71; i = (int)((short)(i + 1))) {
            if (i >= hdrarr.length) {
                headerDets.add("");
                continue;
            }
            headerDets.add(hdrarr[i]);
        }
        this.custPhoneNumber = headerDets.get(1).toString();
        this.custName = headerDets.get(2).toString();
        this.orderAddressStreet = headerDets.get(3).toString();
        this.orderReceiveTime = headerDets.get(4).toString();
        this.orderDestDate = headerDets.get(5).toString();
        this.orderDestTime = headerDets.get(6).toString();
        this.orderAddressComment = headerDets.get(7).toString();
        this.orderDiscounNIS = headerDets.get(8).toString();
        this.orderDeliveryFeeNIS = headerDets.get(9).toString();
        this.orderTotal = headerDets.get(11).toString();
        this.orderNumOfDinners = headerDets.get(24).toString();
        this.orderAddressFloor = headerDets.get(13).toString();
        this.orderAddressFlat = headerDets.get(13).toString();
        this.orderAddressHouse = headerDets.get(15).toString();
        this.orderAddressEntrance = headerDets.get(16).toString();
        this.orderCollectorID = headerDets.get(18).toString();
        this.orderDeliveryFeeInPersent = headerDets.get(23).toString();
        this.orderCustomerNumber = headerDets.get(27).toString();
        this.orderAddressCity = headerDets.get(31).toString();
        this.orderMobilePhoneNumber = headerDets.get(32).toString();
        this.orderMinimumPrice = "";
        this.orderComment = headerDets.get(34).toString();
        this.orderPriceCancelDeliveryFee = "";
        this.orderDiscountInPercent = "";
        this.orderPaymentCibusCompanyId = "";
        this.orderPaymentCibusCardNum = "";
        this.orderCustomerCompanyName = headerDets.get(47).toString();
        this.orderTypeOfPayment = headerDets.get(21).toString();
        this.orderCreditCardNumber = headerDets.get(48).toString();
        this.orderCreditCardValidity = headerDets.get(49).toString();
        this.orderCreditCardCVV = headerDets.get(61).toString();
        this.orderCreditOwnerID = headerDets.get(50).toString();
        this.orderCreditCardSum = headerDets.get(62).toString();
        this.orderCustomerID = headerDets.get(27).toString();
        this.orderPaymentTenbisCompanyID = "";
        this.orderPaymentTenbisCardNum = "";
        this.orderPaymentTenbisSum = headerDets.get(54).toString();
        this.orderCustomerEmail = headerDets.get(56).toString();
        this.orderCustomerPostIndex = "";
        this.orderCustomerFaxNumber = headerDets.get(58).toString();
        this.orderCustomerPhoneNum = headerDets.get(59).toString();
        this.orderSource = headerDets.get(51).toString();
        this.orderCustomerOrderId = headerDets.get(60).toString();
        this.orderGoodiesCard = headerDets.get(69).toString();
        this.orderGoodiesSum = headerDets.get(70).toString();
    }

    public String getCustPhoneNumber() {
        return this.custPhoneNumber;
    }

    public void setCustPhoneNumber(String custPhoneNumber) {
        this.custPhoneNumber = custPhoneNumber;
    }

    public String getCustName() {
        return this.custName;
    }

    public void setCustName(String custName) {
        this.custName = custName;
    }

    public String getOrderAddressStreet() {
        return this.orderAddressStreet;
    }

    public void setOrderAddressStreet(String orderAddressStreet) {
        this.orderAddressStreet = orderAddressStreet;
    }

    public String getOrderReceiveTime() {
        return this.orderReceiveTime;
    }

    public void setOrderReceiveTime(String orderReceiveTime) {
        this.orderReceiveTime = orderReceiveTime;
    }

    public String getOrderDestDate() {
        return this.orderDestDate;
    }

    public void setOrderDestDate(String orderDestDate) {
        this.orderDestDate = orderDestDate;
    }

    public String getOrderDestTime() {
        return this.orderDestTime;
    }

    public void setOrderDestTime(String orderDestTime) {
        this.orderDestTime = orderDestTime;
    }

    public String getOrderComment() {
        return this.orderComment;
    }

    public void setOrderComment(String orderComment) {
        this.orderComment = orderComment;
    }

    public String getOrderDiscounNIS() {
        return this.orderDiscounNIS;
    }

    public void setOrderDiscounNIS(String orderDiscounNIS) {
        this.orderDiscounNIS = orderDiscounNIS;
    }

    public String getOrderDeliveryFeeNIS() {
        return this.orderDeliveryFeeNIS;
    }

    public void setOrderDeliveryFeeNIS(String orderDeliveryFeeNIS) {
        this.orderDeliveryFeeNIS = orderDeliveryFeeNIS;
    }

    public String getOrderTotal() {
        return this.orderTotal;
    }

    public void setOrderTotal(String orderTotal) {
        this.orderTotal = orderTotal;
    }

    public String getOrderAddressFloor() {
        return this.orderAddressFloor;
    }

    public void setOrderAddressFloor(String orderAddressFloor) {
        this.orderAddressFloor = orderAddressFloor;
    }

    public String getOrderAddressFlat() {
        return this.orderAddressFlat;
    }

    public void setOrderAddressFlat(String orderAddressFlat) {
        this.orderAddressFlat = orderAddressFlat;
    }

    public String getOrderAddressHouse() {
        return this.orderAddressHouse;
    }

    public void setOrderAddressHouse(String orderAddressHouse) {
        this.orderAddressHouse = orderAddressHouse;
    }

    public String getOrderAddressEntrance() {
        return this.orderAddressEntrance;
    }

    public void setOrderAddressEntrance(String orderAddressEntrance) {
        this.orderAddressEntrance = orderAddressEntrance;
    }

    public String getOrderTypeOfPayment() {
        return this.orderTypeOfPayment;
    }

    public void setOrderTypeOfPayment(String orderTypeOfPayment) {
        this.orderTypeOfPayment = orderTypeOfPayment;
    }

    public String getOrderDeliveryFeeInPersent() {
        return this.orderDeliveryFeeInPersent;
    }

    public void setOrderDeliveryFeeInPersent(String orderDeliveryFeeInPersent) {
        this.orderDeliveryFeeInPersent = orderDeliveryFeeInPersent;
    }

    public String getOrderCustomerNumber() {
        return this.orderCustomerNumber;
    }

    public void setOrderCustomerNumber(String orderCustomerNumber) {
        this.orderCustomerNumber = orderCustomerNumber;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getOrderAddressCity() {
        return this.orderAddressCity;
    }

    public void setOrderAddressCity(String orderAddressCity) {
        this.orderAddressCity = orderAddressCity;
    }

    public String getOrderMobilePhoneNumber() {
        return this.orderMobilePhoneNumber;
    }

    public void setOrderMobilePhoneNumber(String orderMobilePhoneNumber) {
        this.orderMobilePhoneNumber = orderMobilePhoneNumber;
    }

    public String getOrderMinimumPrice() {
        return this.orderMinimumPrice;
    }

    public void setOrderMinimumPrice(String orderMinimumPrice) {
        this.orderMinimumPrice = orderMinimumPrice;
    }

    public String getOrderPriceCancelDeliveryFee() {
        return this.orderPriceCancelDeliveryFee;
    }

    public void setOrderPriceCancelDeliveryFee(String orderPriceCancelDeliveryFee) {
        this.orderPriceCancelDeliveryFee = orderPriceCancelDeliveryFee;
    }

    public String getOrderPriceCanceldeliveryFee() {
        return this.orderPriceCanceldeliveryFee;
    }

    public void setOrderPriceCanceldeliveryFee(String orderPriceCanceldeliveryFee) {
        this.orderPriceCanceldeliveryFee = orderPriceCanceldeliveryFee;
    }

    public String getOrderDiscountInPercent() {
        return this.orderDiscountInPercent;
    }

    public void setOrderDiscountInPercent(String orderDiscountInPercent) {
        this.orderDiscountInPercent = orderDiscountInPercent;
    }

    public String getOrderPaymentCibusCompanyId() {
        return this.orderPaymentCibusCompanyId;
    }

    public void setOrderPaymentCibusCompanyId(String orderPaymentCibusCompanyId) {
        this.orderPaymentCibusCompanyId = orderPaymentCibusCompanyId;
    }

    public String getOrderPaymentCibusCardNum() {
        return this.orderPaymentCibusCardNum;
    }

    public void setOrderPaymentCibusCardNum(String orderPaymentCibusCardNum) {
        this.orderPaymentCibusCardNum = orderPaymentCibusCardNum;
    }

    public String getOrderCustomerCompanyName() {
        return this.orderCustomerCompanyName;
    }

    public void setOrderCustomerCompanyName(String orderCustomerCompanyName) {
        this.orderCustomerCompanyName = orderCustomerCompanyName;
    }

    public String getOrderCreditCardNumber() {
        return this.orderCreditCardNumber;
    }

    public void setOrderCreditCardNumber(String orderCreditCardNumber) {
        this.orderCreditCardNumber = orderCreditCardNumber;
    }

    public String getOrderCreditCardValidity() {
        return this.orderCreditCardValidity;
    }

    public void setOrderCreditCardValidity(String orderCreditCardValidity) {
        this.orderCreditCardValidity = orderCreditCardValidity;
    }

    public String getOrderCustomerID() {
        return this.orderCustomerID;
    }

    public void setOrderCustomerID(String orderCustomerID) {
        this.orderCustomerID = orderCustomerID;
    }

    public String getOrderSource() {
        return this.orderSource;
    }

    public void setOrderSource(String orderSource) {
        this.orderSource = orderSource;
    }

    public String getOrderPaymentTenbisCompanyID() {
        return this.orderPaymentTenbisCompanyID;
    }

    public void setOrderPaymentTenbisCompanyID(String orderPaymentTenbisCompanyID) {
        this.orderPaymentTenbisCompanyID = orderPaymentTenbisCompanyID;
    }

    public String getOrderPaymentTenbisCardNum() {
        return this.orderPaymentTenbisCardNum;
    }

    public void setOrderPaymentTenbisCardNum(String orderPaymentTenbisCardNum) {
        this.orderPaymentTenbisCardNum = orderPaymentTenbisCardNum;
    }

    public String getOrderPaymentTenbisSum() {
        return this.orderPaymentTenbisSum;
    }

    public void setOrderPaymentTenbisSum(String orderPaymentTenbisSum) {
        this.orderPaymentTenbisSum = orderPaymentTenbisSum;
    }

    public String getOrderCustomerEmail() {
        return this.orderCustomerEmail;
    }

    public void setOrderCustomerEmail(String orderCustomerEmail) {
        this.orderCustomerEmail = orderCustomerEmail;
    }

    public String getOrderCustomerPostIndex() {
        return this.orderCustomerPostIndex;
    }

    public void setOrderCustomerPostIndex(String orderCustomerPostIndex) {
        this.orderCustomerPostIndex = orderCustomerPostIndex;
    }

    public String getOrderCustomerFaxNumber() {
        return this.orderCustomerFaxNumber;
    }

    public void setOrderCustomerFaxNumber(String orderCustomerFaxNumber) {
        this.orderCustomerFaxNumber = orderCustomerFaxNumber;
    }

    public String getOrderCustomerPhoneNum() {
        return this.orderCustomerPhoneNum;
    }

    public void setOrderCustomerPhoneNum(String orderCustomerPhoneNum) {
        this.orderCustomerPhoneNum = orderCustomerPhoneNum;
    }

    public String getOrderCustomerOrderId() {
        return this.orderCustomerOrderId;
    }

    public void setOrderCustomerOrderId(String orderCustomerOrderId) {
        this.orderCustomerOrderId = orderCustomerOrderId;
    }

    public String getOrderCreditOwnerID() {
        return this.orderCreditOwnerID;
    }

    public void setOrderCreditOwnerID(String orderCreditOwnerID) {
        this.orderCreditOwnerID = orderCreditOwnerID;
    }

    public String getOrderCreditCardCVV() {
        return this.orderCreditCardCVV;
    }

    public void setOrderCreditCardCVV(String orderCreditCardCVV) {
        this.orderCreditCardCVV = orderCreditCardCVV;
    }

    public String getOrderCreditCardSum() {
        return this.orderCreditCardSum;
    }

    public void setOrderCreditCardSum(String orderCreditCardSum) {
        this.orderCreditCardSum = orderCreditCardSum;
    }

    public String getOrderNumOfDinners() {
        return this.orderNumOfDinners;
    }

    public void setOrderNumOfDinners(String orderNumOfDinners) {
        this.orderNumOfDinners = orderNumOfDinners;
    }

    public String msmEncr(String custPhoneNumber, String toenc, String dat, String hour, String ordid) {
        String out = "";
        Long orig = Long.valueOf(toenc.trim());
        String mdat = ToOrderFormatUtils.datToMdat(dat);
        Long timetosec = Long.valueOf(hour.substring(0, 2)) * 3600L;
        timetosec = timetosec + (long)Integer.valueOf(hour.substring(3)).intValue() * 60L;
        orig = orig + Long.valueOf(custPhoneNumber) * (long)Integer.valueOf(ordid).intValue();
        orig = orig + Long.valueOf(mdat) * timetosec;
        orig = orig + 17101957L * Long.valueOf(ordid);
        String origstr = String.valueOf(orig);
        for (int i = 0; i < origstr.length(); ++i) {
            int j = origstr.charAt(i) + 18;
            out = out + (char)j;
        }
        return out;
    }

    public String msmDecr(String custPhoneNumber, String todec, String dat, String hour, String ordid) {
        String out = "";
        custPhoneNumber = custPhoneNumber.replace("-", "");
        Long timetosec = Long.valueOf(hour.substring(0, 2)) * 3600L;
        timetosec = timetosec + (long)Integer.valueOf(hour.substring(3)).intValue() * 60L;
        String origstr = String.valueOf(todec);
        for (int i = 0; i < origstr.length(); ++i) {
            int j = origstr.charAt(i) - 18;
            out = out + (char)j;
        }
        String mdat = ToOrderFormatUtils.datToMdat(dat);
        Long val = Long.valueOf(out);
        val = val - Long.valueOf(custPhoneNumber) * (long)Integer.valueOf(ordid).intValue();
        val = val - Long.valueOf(mdat) * timetosec;
        val = val - 17101957L * Long.valueOf(ordid);
        out = String.valueOf(val);
        return out;
    }

    public String getOrderAddressComment() {
        return this.orderAddressComment;
    }

    public void setOrderAddressCommentPoz(String orderAddressCommentPoz) {
        this.orderAddressComment = this.orderAddressComment;
    }

    public String getOrderCollectorID() {
        return this.orderCollectorID;
    }

    public void setOrderCollectorID(String orderCollectorID) {
        this.orderCollectorID = orderCollectorID;
    }

    public String getOrderGoodiesCard() {
        return this.orderGoodiesCard;
    }

    public void setOrderGoodiesCard(String orderGoodiesCard) {
        this.orderGoodiesCard = orderGoodiesCard;
    }

    public String getOrderGoodiesSum() {
        return this.orderGoodiesSum;
    }

    public void setOrderGoodiesSum(String orderGoodiesSum) {
        this.orderGoodiesSum = orderGoodiesSum;
    }

    public String getOrderPaymentCibusSum() {
        return this.orderPaymentCibusSum;
    }

    public void setOrderPaymentCibusSum(String orderPaymentCibusSum) {
        this.orderPaymentCibusSum = orderPaymentCibusSum;
    }

    public String getOrderClientCreditTotal() {
        return this.orderClientCreditTotal;
    }
}

