/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.resources;

import com.genorder.bean.GeneralOrder;
import com.genorder.resources.GetSoOrderDetailtsExV3;
import com.openrest.order.beans.SoMenu;
import com.openrest.order.beans.SoMenuMap;
import com.openrest.order.beans.v3.Data;
import com.openrest.order.beans.v3.Entity;
import com.wix.restaurants.i18n.Locale;
import com.wix.restaurants.json.Json;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

public class ConvertSoV3OrderToGeneralOrder
extends GetSoOrderDetailtsExV3 {
    private GeneralOrder gord;
    private Entity soOrderAndCredit;
    private SoMenuMap soMenuMap;
    private Locale lang = new Locale("he_IL");
    private String posType = "";

    public void ConvertSOExToGeneralOrder(Data jsonData) throws Exception {
        String restid = "";
        if (jsonData.getCreatedEvent() == null) {
            this.setSoOrderAndCredit(jsonData.getActionEvent().getBody().getOrder());
            restid = jsonData.getActionEvent().getBody().getOrder().getRestaurantId();
        } else {
            this.setSoOrderAndCredit(jsonData.getCreatedEvent().getEntity());
            restid = jsonData.getCreatedEvent().getEntity().getRestaurantId();
        }
        File menufile = new File("/pos/tmp/menufile_" + restid);
        if (menufile.exists()) {
            FileInputStream is = new FileInputStream(menufile);
            this.soMenuMap = Json.mapper.readValue((InputStream)is, SoMenuMap.class);
            ((InputStream)is).close();
        } else {
            SoMenu osm = this.getMenu(restid);
            this.setSoMenuMap(new SoMenuMap(osm, this.getLang(), this.posType));
            FileOutputStream os = new FileOutputStream(menufile);
            Json.mapper.writeValue(os, (Object)this.soMenuMap);
            os.flush();
            ((OutputStream)os).close();
        }
        this.ConvertSOExToGeneralOrder(this.getSoOrderAndCredit(), this.getSoMenuMap());
    }

    private void ConvertSOExToGeneralOrder(Entity om, SoMenuMap somm) throws Exception {
        this.gord = new GeneralOrder();
        this.gord.setOrder_id(this.getOrderId());
        this.gord.setAddress(this.getOrderAddress(om));
        this.gord.setOrder_date_delivery(this.getOrderDateDeliveryTime(om));
        this.gord.setDelivery_fee(this.getOrderDeliveryFee(om));
        this.gord.setOrder_contact(this.getOrderContacts(om));
        this.gord.setOrder_items(this.getOrderItemsV3(om, somm));
        this.gord.setOrder_source(this.getOrderSource(om));
        this.gord.setOrder_contact(this.getOrderContacts(om));
        this.gord.setOrder_remark(this.getOrderComment(om));
        this.gord.setPayments(this.getOrderPayment(om));
        this.gord.setOrder_rest(this.getOrderRestaurant(om));
        this.gord.setOrder_total(this.getOrderTotal(om));
        this.gord.setNum_of_dinners(this.getNumOfDinners(om));
        this.gord.setOrder_discount(this.getOrderDiscount(om));
        this.gord.setOrder_tip(this.getOrderTip(om));
    }

    public Locale getLang() {
        return this.lang;
    }

    public void setLang(Locale lang) {
        this.lang = lang;
    }

    public GeneralOrder getGord() {
        return this.gord;
    }

    public void setGord(GeneralOrder gord) {
        this.gord = gord;
    }

    public Entity getSoOrderAndCredit() {
        return this.soOrderAndCredit;
    }

    public void setSoOrderAndCredit(Entity soOrderAndCredit) {
        this.soOrderAndCredit = soOrderAndCredit;
    }

    public SoMenuMap getSoMenuMap() {
        return this.soMenuMap;
    }

    public void setSoMenuMap(SoMenuMap soMenuMap) {
        this.soMenuMap = soMenuMap;
    }

    private SoMenu getMenu(String restId) throws URISyntaxException, MalformedURLException, IOException {
        URI jsonUrl = new URI("https://api.wixrestaurants.com/v2/organizations/" + restId + "/full");
        SoMenu soMenu = Json.mapper.readValue(jsonUrl.toURL(), SoMenu.class);
        return soMenu;
    }

    public String getPosType() {
        return this.posType;
    }

    public void setPosType(String posType) {
        this.posType = posType;
    }
}

