/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.olo.dispatches;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.openrest.olo.dispatches.DeliveryDispatchInfo;
import com.openrest.olo.dispatches.PickupDispatchInfo;
import com.openrest.olo.dispatches.PremisesDispatchInfo;
import com.wix.restaurants.availability.Availability;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PickupDispatchInfo.class, name="takeout"), @JsonSubTypes.Type(value=DeliveryDispatchInfo.class, name="delivery"), @JsonSubTypes.Type(value=PremisesDispatchInfo.class, name="premises")})
public abstract class DispatchInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Integer minOrderPrice = 0;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Integer charge = 0;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Integer delayMins = 0;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Boolean inactive = Boolean.FALSE;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Availability availability = new Availability();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> properties = new LinkedHashMap<String, String>();

    public DispatchInfo() {
    }

    public DispatchInfo(Integer minOrderPrice, Integer charge, Integer delayMins, Boolean inactive, Availability availability, Map<String, String> properties) {
        this.minOrderPrice = minOrderPrice;
        this.charge = charge;
        this.delayMins = delayMins;
        this.inactive = inactive;
        this.availability = availability;
        this.properties = properties;
    }

    public DispatchInfo clone() {
        return this.cloneImpl();
    }

    protected abstract DispatchInfo cloneImpl();

    public static List<DispatchInfo> clone(List<DispatchInfo> dispatchInfos) {
        if (dispatchInfos == null) {
            return null;
        }
        LinkedList<DispatchInfo> cloned = new LinkedList<DispatchInfo>();
        for (DispatchInfo dispatchInfo : dispatchInfos) {
            cloned.add(dispatchInfo != null ? dispatchInfo.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DispatchInfo that = (DispatchInfo)o;
        return Objects.equals(this.minOrderPrice, that.minOrderPrice) && Objects.equals(this.charge, that.charge) && Objects.equals(this.delayMins, that.delayMins) && Objects.equals(this.inactive, that.inactive) && Objects.equals(this.availability, that.availability) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.minOrderPrice, this.charge, this.delayMins, this.inactive, this.availability, this.properties);
    }
}

