/*
 * Decompiled with CFR 0.152.
 */
package com.genorder.resources;

import com.frsvision.bean.CustomerType;
import com.frsvision.bean.DataType;
import com.frsvision.bean.GenericType;
import com.frsvision.bean.ItemType;
import com.frsvision.bean.ItemsType;
import com.frsvision.bean.OrderType;
import com.frsvision.bean.OrdersType;
import com.frsvision.bean.ShippingAddressType;
import com.frsvision.resources.pos.Error;
import com.frsvision.resources.pos.FrsvisionException;
import com.genorder.bean.GeneralOrder;
import com.genorder.bean.OrderItem;
import com.genorder.bean.Payment;
import com.genorder.bean.PaymentCibus;
import com.openrest.resources.ConvertSoV3OrderToGeneralOrder;
import java.io.UnsupportedEncodingException;

public class ConvertGeneralToFrsOrderV3
extends ConvertSoV3OrderToGeneralOrder {
    private GenericType frsOtrder;

    public void ConvertGenToFrsOrder(Integer status) throws UnsupportedEncodingException, FrsvisionException {
        this.frsOtrder = new GenericType();
        String frsCreditInfo = "";
        for (Payment genPay : this.getGord().getPayments()) {
            if (genPay.getPayment_id() == 1) {
                this.getFrsOtrder().setCommand("CashWithDetails");
                continue;
            }
            if (genPay instanceof PaymentCibus) {
                this.getFrsOtrder().setCommand("ChargeOtherWithDetails");
                frsCreditInfo = "601|" + this.getGord().getOrder_source().getSource_id() + "|0";
                continue;
            }
            if ("".equals(genPay.getPayment_card_dets().getCc_number())) {
                this.getFrsOtrder().setCommand("ChargeOtherWithDetails");
                frsCreditInfo = "70|" + this.getGord().getOrder_source().getSource_id() + "|0";
                continue;
            }
            frsCreditInfo = genPay.getPayment_card_dets().getCc_number() + "|";
            frsCreditInfo = frsCreditInfo + genPay.getPayment_card_dets().getCc_exp().replace("/", "") + "|";
            frsCreditInfo = frsCreditInfo + genPay.getPayment_card_dets().getCc_owner_id() + "|";
            frsCreditInfo = frsCreditInfo + genPay.getPayment_card_dets().getCc_cvv();
            this.getFrsOtrder().setCommand("Credit");
        }
        this.getFrsOtrder().setExtraInfo(frsCreditInfo);
        this.getFrsOtrder().setData(this.genDataType(this.getGord(), status));
    }

    private DataType genDataType(GeneralOrder genord, Integer orderStatus) throws FrsvisionException {
        DataType frsDataType = new DataType();
        frsDataType.setCustomer(this.genFrsCustomerType(genord));
        frsDataType.setOrders(this.genFrsOrdersType(genord, orderStatus));
        frsDataType.setItems(this.genFrsItemsType(genord));
        frsDataType.setShippingAddress(this.genFrsShippingAddressType(genord));
        return frsDataType;
    }

    private CustomerType genFrsCustomerType(GeneralOrder genord) {
        CustomerType frsCustomerType = new CustomerType();
        frsCustomerType.setApartment(genord.getAddress().getAppartment());
        frsCustomerType.setBuilding(0);
        frsCustomerType.setFloor("-");
        frsCustomerType.setStreetCode("5000-033");
        String areacode = genord.getOrder_contact().get(0).getContact_phone().split("-")[0];
        String phone = genord.getOrder_contact().get(0).getContact_phone().split("-")[1];
        frsCustomerType.setAreaCode(areacode);
        frsCustomerType.setCellularNo("");
        frsCustomerType.setEmail(genord.getOrder_contact().get(0).getContact_email());
        frsCustomerType.setEntrance("-");
        frsCustomerType.setFirstName(genord.getOrder_contact().get(0).getContact_firstname());
        frsCustomerType.setIDType(1);
        frsCustomerType.setLastName(genord.getOrder_contact().get(0).getContact_lastname());
        frsCustomerType.setPhoneNo(phone);
        String addr_comment = "";
        String city = genord.getAddress().getCity();
        if ("TAW".equals(city)) {
            city = "\u05d9\u05d1\u05d5\u05d0 \u05dc\u05e7\u05d7\u05ea";
            addr_comment = addr_comment + city + " ,";
        } else {
            addr_comment = addr_comment + genord.getAddress().getStreet() + " " + genord.getAddress().getHouse_number() + " ,";
            addr_comment = addr_comment + city + " ,";
            addr_comment = addr_comment + "\u05db\u05e0\u05d9\u05e1\u05d4   : " + genord.getAddress().getEntrance() + " ,";
            addr_comment = addr_comment + "\u05e7\u05d5\u05de\u05d4   : " + genord.getAddress().getFloor_num() + " ,";
            addr_comment = addr_comment + "\u05d3\u05d9\u05e8\u05d4  : " + genord.getAddress().getAppartment() + " ,";
        }
        addr_comment = addr_comment + genord.getAddress().getAddress_remark();
        frsCustomerType.setAddressComment(this.maxSizeRemark(addr_comment));
        frsCustomerType.setAddressNote(this.maxSizeRemark(addr_comment));
        return frsCustomerType;
    }

    private OrdersType genFrsOrdersType(GeneralOrder genord, Integer orderStatus) {
        OrdersType frsOrdersType = new OrdersType();
        frsOrdersType.setOrder(this.genFrsOrderType(genord, orderStatus));
        return frsOrdersType;
    }

    private OrderType genFrsOrderType(GeneralOrder genord, Integer orderStatus) {
        OrderType frsOrderType = new OrderType();
        frsOrderType.setComment(genord.getOrder_remark());
        frsOrderType.setDinersNo(1);
        frsOrderType.setECRNo(101);
        frsOrderType.setEmployeeID(1);
        frsOrderType.setPrinted("");
        frsOrderType.setSaleCode(2);
        frsOrderType.setStatus(orderStatus);
        frsOrderType.setTotal(genord.getOrder_total());
        return frsOrderType;
    }

    private ItemsType genFrsItemsType(GeneralOrder genord) throws FrsvisionException {
        ItemsType frsItemsType = new ItemsType();
        frsItemsType.getItem().addAll(this.genFrsAddressToItems(genord).getItem());
        Integer main_level = frsItemsType.getItem().size();
        Integer next_level = 0;
        main_level = main_level + 1;
        String itemPlace = String.format("%03d", main_level);
        frsItemsType.getItem().add(this.genFrsGenItemType("995018", " ------------- ", "0", itemPlace));
        for (OrderItem oi : genord.getOrder_items()) {
            if (oi.getItem_pos_id().contains("0-")) {
                throw new FrsvisionException(new Error(Error.ERROR_POS_MISSING_ITEM_NUMBER, "Invalid  Pos item id " + oi.getItem_source_id() + "|" + oi.getItem_name()));
            }
            if (oi.getItem_pos_id().contains("\u05d5\u05d9\u05e8\u05d8\u05d5\u05d0\u05dc\u05d9")) continue;
            if (oi.getItem_level() == 0) {
                main_level = main_level + 1;
                next_level = 0;
                itemPlace = String.format("%03d", main_level);
            } else {
                next_level = next_level + 1;
                itemPlace = String.format("%03d%03d", main_level, next_level);
            }
            frsItemsType.getItem().add(this.genFrsItemType(oi, itemPlace));
        }
        main_level = main_level + 1;
        itemPlace = String.format("%03d", main_level);
        frsItemsType.getItem().add(this.genFrsGenItemType("995018", " ------------- ", "0", itemPlace));
        main_level = main_level + 1;
        itemPlace = String.format("%03d", main_level);
        frsItemsType.getItem().add(this.genFrsGenItemType("2", "\u05d4\u05e0\u05d7\u05d4 ", "-" + genord.getOrder_discount(), itemPlace));
        main_level = main_level + 1;
        itemPlace = String.format("%03d", main_level);
        frsItemsType.getItem().add(this.genFrsGenItemType("1", "\u05d3\u05de\u05d9 \u05de\u05e9\u05dc\u05d5\u05d7 ", genord.getDelivery_fee(), itemPlace));
        return frsItemsType;
    }

    private ItemsType genFrsAddressToItems(GeneralOrder genord) {
        ItemsType frsItemsType = new ItemsType();
        ItemType frsItemType = new ItemType();
        Integer main_level = 0;
        String city = genord.getAddress().getCity();
        main_level = main_level + 1;
        String itemPlace = String.format("%03d", main_level);
        String cityItem = city;
        if ("TAW".equals(city)) {
            cityItem = "\u05d9\u05d1\u05d5\u05d0 \u05dc\u05e7\u05d7\u05ea";
        }
        frsItemsType.getItem().add(this.genFrsGenItemType("995018", cityItem, "0", itemPlace));
        if (!"TAW".equals(city)) {
            String street = genord.getAddress().getStreet() + " " + genord.getAddress().getHouse_number();
            main_level = main_level + 1;
            itemPlace = String.format("%03d", main_level);
            frsItemsType.getItem().add(this.genFrsGenItemType("995018", street, "0", itemPlace));
            String entry = "\u05db\u05e0\u05d9\u05e1\u05d4   " + genord.getAddress().getEntrance();
            main_level = main_level + 1;
            itemPlace = String.format("%03d", main_level);
            frsItemsType.getItem().add(this.genFrsGenItemType("995018", entry, "0", itemPlace));
            String floor = "\u05e7\u05d5\u05de\u05d4   " + genord.getAddress().getFloor_num();
            main_level = main_level + 1;
            itemPlace = String.format("%03d", main_level);
            frsItemsType.getItem().add(this.genFrsGenItemType("995018", floor, "0", itemPlace));
            String apt = "\u05d3\u05d9\u05e8\u05d4  " + genord.getAddress().getAppartment();
            main_level = main_level + 1;
            itemPlace = String.format("%03d", main_level);
            frsItemsType.getItem().add(this.genFrsGenItemType("995018", apt, "0", itemPlace));
        }
        String address_remark = genord.getAddress().getAddress_remark();
        main_level = main_level + 1;
        itemPlace = String.format("%03d", main_level);
        frsItemsType.getItem().add(this.genFrsGenItemType("995018", this.maxSizeRemark(address_remark), "0", itemPlace));
        return frsItemsType;
    }

    private ItemType genFrsItemType(OrderItem oi, String itemPlace) {
        ItemType frsItemType = new ItemType();
        frsItemType.setPlace(itemPlace);
        frsItemType.setCnt(oi.getItem_qty());
        frsItemType.setOriginalPrice(oi.getItem_price());
        frsItemType.setItemNo(oi.getItem_pos_id());
        frsItemType.setPrice(oi.getItem_price());
        frsItemType.setRemark(this.maxSizeRemark(oi.getItem_comment()));
        frsItemType.setFromSale("2");
        frsItemType.setNew("True");
        frsItemType.setSum(oi.getItem_total());
        return frsItemType;
    }

    private ItemType genFrsGenItemType(String itemPosId, String itemComment, String itemPrice, String itemPlace) {
        ItemType frsItemType = new ItemType();
        frsItemType.setCnt("1");
        frsItemType.setFromSale("2");
        frsItemType.setNew("true");
        frsItemType.setOriginalPrice(itemPrice);
        frsItemType.setPrice(itemPrice);
        frsItemType.setSum(itemPrice);
        frsItemType.setItemNo(itemPosId);
        frsItemType.setRemark(this.maxSizeRemark(itemComment));
        frsItemType.setPlace(itemPlace);
        return frsItemType;
    }

    private ItemType genFrsItemType(String itemCnt, String itemPrice, String itemPosId, String itemComment, String itemTotal, String itemPlace) {
        ItemType frsItemType = new ItemType();
        frsItemType.setPlace(itemPlace);
        frsItemType.setCnt(itemCnt);
        frsItemType.setOriginalPrice(itemPrice);
        frsItemType.setItemNo(itemPosId);
        frsItemType.setPrice(itemPrice);
        frsItemType.setRemark(this.maxSizeRemark(itemComment));
        frsItemType.setFromSale("2");
        frsItemType.setNew("True");
        frsItemType.setSum(itemTotal);
        return frsItemType;
    }

    private ShippingAddressType genFrsShippingAddressType(GeneralOrder genord) {
        ShippingAddressType frsShippingAddressType = new ShippingAddressType();
        int apt = 0;
        frsShippingAddressType.setShippingAddressApartment(apt);
        frsShippingAddressType.setShippingAddressCityID("5000");
        frsShippingAddressType.setShippingAddressCityName(genord.getAddress().getCity());
        frsShippingAddressType.setShippingAddressCompany("-");
        frsShippingAddressType.setShippingAddressDoorName("-");
        frsShippingAddressType.setShippingAddressEntrance("-");
        frsShippingAddressType.setShippingAddressFloor("-");
        int building = 0;
        frsShippingAddressType.setShippingAddressHouseNumber(building);
        frsShippingAddressType.setShippingAddressLatitude("");
        frsShippingAddressType.setShippingAddressLongitude("");
        frsShippingAddressType.setShippingAddressStreetID("5000-033");
        frsShippingAddressType.setShippingAddressStreetName("-");
        frsShippingAddressType.setShippingAddressZipCode("-");
        String addr_comment = "";
        addr_comment = addr_comment + genord.getAddress().getStreet() + " " + genord.getAddress().getHouse_number() + " ,";
        addr_comment = addr_comment + genord.getAddress().getCity() + " ,";
        addr_comment = addr_comment + "\u05db\u05e0\u05d9\u05e1\u05d4   : " + genord.getAddress().getEntrance() + " ,";
        addr_comment = addr_comment + "\u05e7\u05d5\u05de\u05d4   : " + genord.getAddress().getFloor_num() + " ,";
        addr_comment = addr_comment + "\u05d3\u05d9\u05e8\u05d4  : " + genord.getAddress().getAppartment() + " ,";
        addr_comment = addr_comment + genord.getAddress().getAddress_remark();
        frsShippingAddressType.setShippingAddressAddressNotes(this.maxSizeRemark(addr_comment));
        return frsShippingAddressType;
    }

    private String maxSizeRemark(String str) {
        if (str.length() > 254) {
            return this.cleanFromSpecChars(str.substring(0, 249) + "...");
        }
        return this.cleanFromSpecChars(str);
    }

    private String cleanFromSpecChars(String str) {
        String cleanStr = str.replaceAll("\n", "|");
        cleanStr = cleanStr.replaceAll("<", "");
        cleanStr = cleanStr.replaceAll(">", "");
        cleanStr = cleanStr.replaceAll("\"", "");
        cleanStr = cleanStr.replaceAll("'", "");
        cleanStr = cleanStr.replaceAll("&", "");
        return cleanStr;
    }

    public GenericType getFrsOtrder() {
        return this.frsOtrder;
    }

    public void setFrsOtrder(GenericType frsOtrder) {
        this.frsOtrder = frsOtrder;
    }
}

