/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.DirectoryListArgument;
import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestListings
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestListings.java,v 1.15 2010-09-14 00:44:58 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestListings;

    protected String getLogName() {
        return "TestListings.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testDir() throws Exception {
        log.debug("testDir() - ENTRY");
        try {
            block4: {
                this.connect();
                this.ftp.chdir(this.testdir);
                String[] list = this.ftp.dir();
                this.print(list);
                list = this.ftp.dir(".");
                this.print(list);
                log.debug("Testing for empty dir: " + this.remoteEmptyDir);
                list = this.ftp.dir(this.remoteEmptyDir);
                this.print(list);
                log.debug("End testing for empty dir");
                String randomName = this.generateRandomFilename();
                try {
                    list = this.ftp.dir(randomName);
                    this.print(list);
                }
                catch (FTPException ex) {
                    if (ex.getReplyCode() == 550 || ex.getReplyCode() == 450 || ex.getReplyCode() == 2) break block4;
                    TestListings.fail((String)("dir(" + randomName + ") should throw 450/550 for non-existent dir"));
                }
            }
            this.ftp.quit();
            Object var5_4 = null;
            log.debug("testDir() - EXIT");
            if (!this.ftp.connected()) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            log.debug("testDir() - EXIT");
            if (!this.ftp.connected()) throw throwable;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testDirFull() throws Exception {
        log.debug("testDirFull() - ENTRY");
        try {
            block4: {
                this.connect();
                this.ftp.chdir(this.testdir);
                String[] list = this.ftp.dir(".", true);
                this.print(list);
                log.debug("******* dirDetails *******");
                FTPFile[] files2 = this.ftp.dirDetails(".");
                this.print(files2);
                log.debug("******* end dirDetails *******");
                log.debug("Testing for empty dir: " + this.remoteEmptyDir);
                list = this.ftp.dir(this.remoteEmptyDir, true);
                this.print(list);
                log.debug("End testing for empty dir");
                String randomName = this.generateRandomFilename();
                log.debug("Testing for non-existent dir: " + randomName);
                try {
                    list = this.ftp.dir(randomName, true);
                    this.print(list);
                }
                catch (FTPException ex) {
                    if (ex.getReplyCode() == 550 || ex.getReplyCode() == 450 || ex.getReplyCode() == 2) break block4;
                    TestListings.fail((String)("dir(" + randomName + ") should throw 450/550/2 for non-existent dir"));
                }
            }
            this.ftp.quit();
            Object var6_5 = null;
            log.debug("testDirFull() - EXIT");
            if (!this.ftp.connected()) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            log.debug("testDirFull() - EXIT");
            if (!this.ftp.connected()) throw throwable;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testDirFull2() throws Exception {
        log.debug("testDirFull2() - ENTRY");
        try {
            this.connect();
            this.ftp.chdir(this.testdir);
            FTPFile[] files2 = this.ftp.dirDetails(".");
            DirCallback dirCallback = new DirCallback();
            this.ftp.dirDetails(".", dirCallback);
            if (dirCallback.getFiles().size() != files2.length) {
                log.debug("Callback=" + dirCallback.getFiles().size() + ", listing=" + files2.length);
                Iterator i = dirCallback.getFiles().keySet().iterator();
                while (i.hasNext()) {
                    log.debug((String)i.next());
                }
                log.debug("Listing=" + files2.length);
                for (int j = 0; j < files2.length; ++j) {
                    log.debug(files2[j].getName());
                }
                TestListings.fail((String)"Mismatch in listing length");
            }
            log.debug("Listing lengths match!");
            boolean allFound = true;
            for (int i = 0; i < files2.length; ++i) {
                if (dirCallback.getFiles().get(files2[i].getName()) != null) continue;
                log.debug("Failed to find " + files2[i].getName());
                allFound = false;
            }
            if (!allFound) {
                Iterator i = dirCallback.getFiles().values().iterator();
                while (i.hasNext()) {
                    log.debug(((FTPFile)i.next()).getName());
                }
                TestListings.fail((String)"Failed to find all files");
            }
            this.ftp.quit();
            Object var6_7 = null;
            log.debug("testDirFull2() - EXIT");
            if (!this.ftp.connected()) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            log.debug("testDirFull2() - EXIT");
            if (!this.ftp.connected()) throw throwable;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestListings == null ? (class$com$enterprisedt$net$ftp$test$TestListings = TestListings.class$("com.enterprisedt.net.ftp.test.TestListings")) : class$com$enterprisedt$net$ftp$test$TestListings);
    }

    public static void main(String[] args2) {
        TestRunner.run((Test)TestListings.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DirCallback
    implements DirectoryListCallback {
        private Map files = new HashMap();

        DirCallback() {
        }

        public void listDirectoryEntry(DirectoryListArgument arg) {
            this.files.put(arg.getEntry().getName(), arg.getEntry());
        }

        public Map getFiles() {
            return this.files;
        }
    }
}

