/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.CodeSource;

public class VersionDetails {
    private static final String majorVersion = "2";
    private static final String middleVersion = "5";
    private static final String minorVersion = "0";
    private static int[] version;
    private static String versionString;
    private static final String buildTimestamp = "6-Jul-2016 11:07:02 BST";

    public static final int[] getVersion() {
        return version;
    }

    public static final String getVersionString() {
        return versionString;
    }

    public static final String getBuildTimestamp() {
        return buildTimestamp;
    }

    public static final String report(Object obj) {
        StringWriter result2 = new StringWriter();
        PrintWriter report = new PrintWriter((Writer)result2, true);
        try {
            if (obj != null) {
                report.print("Class: ");
                report.println(obj.getClass().getName());
                report.print("Location: ");
                CodeSource cs = obj.getClass().getProtectionDomain().getCodeSource();
                if (cs != null) {
                    report.println(cs.getLocation().toString());
                } else {
                    report.println("unknown");
                }
            } else {
                report.print("Null object supplied");
            }
            report.print("Version: ");
            report.println(versionString);
            report.print("Build timestamp: ");
            report.println(buildTimestamp);
            report.print("Java version: ");
            report.println(System.getProperty("java.version"));
            report.print("CLASSPATH: ");
            report.println(System.getProperty("java.class.path"));
            report.print("OS name: ");
            report.println(System.getProperty("os.name"));
            report.print("OS arch: ");
            report.println(System.getProperty("os.arch"));
            report.print("OS version: ");
            report.println(System.getProperty("os.version"));
        }
        catch (Throwable ex) {
            report.println("Could not obtain version details: " + ex.getMessage());
        }
        return result2.toString();
    }

    static {
        try {
            version = new int[3];
            VersionDetails.version[0] = Integer.parseInt(majorVersion);
            VersionDetails.version[1] = Integer.parseInt(middleVersion);
            VersionDetails.version[2] = Integer.parseInt(minorVersion);
            versionString = version[0] + "." + version[1] + "." + version[2];
        }
        catch (NumberFormatException ex) {
            System.err.println("Failed to calculate version: " + ex.getMessage());
            versionString = "Unknown";
        }
    }
}

