/*
 * Decompiled with CFR 0.152.
 */
package com.cav.mserver;

import com.cav.mserver.Config;
import com.cav.mserver.MumpsConsoleSession;
import com.cav.mserver.TelnetClient;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MumpsTelnetSession
extends MumpsConsoleSession {
    private static Logger logger = Logger.getLogger(MumpsTelnetSession.class.getPackage().getName());
    private TelnetClient telnetClient;

    public MumpsTelnetSession() throws IOException {
        this.init();
    }

    public MumpsTelnetSession(String host, int port, String user, String password, int timeout2) throws IOException {
        this.init(host, port, user, password, timeout2);
    }

    @Override
    public void close() {
        try {
            this.executeCommand("HALT");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error sending HALT command", e);
        }
        try {
            this.telnetClient.disconnect();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error disconnecting telnet", e);
        }
    }

    @Override
    public void init() throws IOException {
        String host = Config.getString("telnet.host");
        String portStr = Config.getString("telnet.port");
        int port = 23;
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String user = Config.getString("telnet.user");
        String password = Config.getString("telnet.password");
        String timeoutStr = Config.getString("telnet.timeout");
        int timeout2 = 0;
        if (timeoutStr != null) {
            try {
                timeout2 = Integer.parseInt(timeoutStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.init(host, port, user, password, timeout2);
    }

    private void init(String host, int port, String user, String password, int timeout2) throws IOException {
        this.telnetClient = new TelnetClient(host, port, timeout2);
        this.telnetClient.login(user, password);
        this.consoleStdin = new PrintStream(this.telnetClient.getOutputStream());
        this.consoleStdout = this.telnetClient.getInputStream();
    }
}

