;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;								;
; Copyright (c) 2015-2025 Fidelity National Information		;
; Services, Inc. and/or its subsidiaries. All rights reserved.	;
;								;
;	This source code contains the intellectual property	;
;	of its copyright holder(s), and is made available	;
;	under a license.  If you do not know the terms of	;
;	the license, please stop and do not read further.	;
;								;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
%ZSHOWVTOLCL(%ZSHOWvbase)	; retrieve locals from a ZSHOW "V" probably from a global
	; %ZSHOWvbase is the target location of the zshow "v" and the only thing this can't and won't restore; failure to do so
	; produces a message, but is not considered an error that stops processing by this utility.
	; in order to have a minimum restriction on what it can instantiate for local variables, this uses a single array with a
	; weird name, which makes it not much fun to read (sorry).
	; It may be invoked either as an extrinsic that returns TRUE (1) for success or negative count of lovals skipped for partial
	; success or FALSE (0) for failure, or with a DO.
	; As of this writing, it is expected to typically be a programmer's tool so, while it does a reasonable amount of condition
	; validation, it does not currently handle almost any GT.M errors, say likely due to input that's formed by something other
	; than ZWRITE "V" rather it relies on the current error trap, and it sends its messages of validation issues to $PRINCIPAL;
	; see sendmsg below if you want to change that.
	; It responds to a non-zero definition of debug by breaking on some termination states which aren't suited to ZBREAK.
	; It rejects cases where the value is close to 1 Mib & a long global key that doesn't fit in a short DB block - see TODO.

	if '+$get(debug) new debug set debug=0
	if ""'=$ecode do sendmsg("m0",.%ZSHOWvbase) quit:$quit 0 quit				; need to start "error free"
	if "^"'=$zextract($qsubscript(%ZSHOWvbase,0)) do sendmsg("m1",.%ZSHOWvbase,%ZSHOWvbase) quit:$quit 0 quit
	set %ZSHOWvbase("x")=%ZSHOWvbase						; setup & find lvn output from ZSHOW
	set %ZSHOWvbase("depth")=$qlength(%ZSHOWvbase("x"))+1,%ZSHOWvbase("length")=$zlength(%ZSHOWvbase("x"))-1
	for %ZSHOWvbase("i")=1:1:%ZSHOWvbase("depth") quit:"V"=$qsubscript(%ZSHOWvbase("x"),%ZSHOWvbase("i"))
	if %ZSHOWvbase("i")=%ZSHOWvbase("depth") do					; add a trailing "V"
	. if %ZSHOWvbase("x")["(" set %ZSHOWvbase("x")=$zextract(%ZSHOWvbase("x"),1,%ZSHOWvbase("length"))_",""V"")"
	. else  set %ZSHOWvbase("x")=%ZSHOWvbase("x")_"(""V"")"
	. set %ZSHOWvbase("depth")=%ZSHOWvbase("depth")+1
	else  if %ZSHOWvbase("i")+1=%ZSHOWvbase("depth"),"V"=$qsubscript(%ZSHOWvbase("x"),%ZSHOWvbase("depth")-1)	;just fine
	else  if %ZSHOWvbase("i")+2=%ZSHOWvbase("depth"),1=$qsubscript(%ZSHOWvbase("x"),%ZSHOWvbase("depth")-1)  do	; strip 1
	. set $zextract(%ZSHOWvbase("x"),%ZSHOWvbase("length")-1,%ZSHOWvbase("length"))=""
	. set %ZSHOWvbase("depth")=%ZSHOWvbase("depth")-1
	else  do sendmsg("m2",.%ZSHOWvbase,%ZSHOWvbase("x")) quit:$quit 0 quit
	if 1'<$data(@%ZSHOWvbase("x")) do sendmsg("m3",.%ZSHOWvbase,%ZSHOWvbase("x")) quit:$quit 0 quit
	for %ZSHOWvbase("index")=1:1 set %ZSHOWvbase("ret")=$$item(.%ZSHOWvbase) quit:""=%ZSHOWvbase("ret")  do		; each lvn
	. if "o"=%ZSHOWvbase("ret") set @%ZSHOWvbase("val") quit			; argument indirection
	. set:"d"=%ZSHOWvbase("ret") @%ZSHOWvbase("key")=%ZSHOWvbase("val")		; atomic indirection
	if $get(%ZSHOWvbase("cnt")) do sendmsg("m8",.%ZSHOWvbase,%ZSHOWvbase("cnt")) quit:$quit -%ZSHOWvbase("cnt")
	kill *%ZSHOWvbase								; the QUIT above leaves the alias
	quit:$quit 1 quit

item(x)
	new cindex,cp,data,indx,len,qoff,qptr,raw,value,wed				; comprehensive list for subroutine
	set data=$data(@x("x")@(x("index")))
	quit:'data ""									; no more for call
	if 10=data do  quit 1								; bad format but only for this variable
	. set $zextract(x("x"),$zlength(x("x")))=","_x("index")_")"
	. do sendmsg("m3",.x,x("x"))
	set raw=@x("x")@(x("index"))
	if "%ZSHOWvbase"=$zextract(raw,1,$zlength("%ZSHOWvbase")) do  quit x("ret")	; can't mess with our working namespace
	. do sendmsg("m4",.x,raw)
	set x("val")=""
	for cindex=1:1 do  quit:""=raw
	. set:" ;*"=$zextract(raw,$zlength(raw)-2,$zlength(raw)) $zextract(raw,$zlength(raw)-2,$zlength(raw))=""
	. if ((2**20)<($zlength(x("val"))+$zlength(raw))) set x("val")="",raw=""  quit
	. set x("val")=x("val")_raw,raw=$get(@x("x")@(x("index"),cindex))
	if ""'=x("val") do  quit:""'=x("val") "o"					; done - set @x should do it
	. new $etrap set $etrap="set ($ecode,x(""val""))="""""				; but in case it doesn't
	. set @x("val")
	set raw=@x("x")@(x("index")),(qptr,qoff,x("ret"))=1
	set indx=$zfind(raw,"=",qptr),qptr=$zfind(raw,"""",qptr)			; find 1st equal-sign thats not in quotes
	if indx,qptr,indx>qptr do  if 'qptr!'indx set:'qoff indx=0			; perhaps quotes in key
	. for  set qptr=$zfind(raw,"""",qptr) quit:'qptr!(qptr>indx)  set:'qoff qoff=1 set indx=$zfind(raw,"=",qptr)
	; this logic doesn't deal with combining a long ZSHOW "V" target key, long local key, long value, and smallish record size
	if 'indx do sendmsg("m5",.x,@x("x")@(x("index"))) quit x("ret")			; and the above gives this error
	set x("key")=$zextract(raw,1,indx-2)						; strip off key and equal-sign
	set qoff=1,$zextract(raw,1,indx-1)="",x("val")=""
	if "$"""'[$zextract(raw) set:+raw=raw x("val")=raw				; ending numberic
	for cindex=1:1 do  quit:'cindex							; loop thru continuation nodes
	. if 10=$data(@x("x")@(x("index"),cindex)) do  set cindex=0 quit		; stop if non-conforming
	. . do sendmsg("m2",.x,x("x"))
	. set cp=$zfind(raw,"_"),qptr=$zfind(raw,"""",1+(1=cindex))			; 1st node differs from continations
	. if 'cp,'qptr do  quit:'cindex
	. . if ((2**20)<($zlength(x("val"))+$zlength(raw))) do sendmsg("m6",.x,x("key")) set cindex=0,x("val")=""	; won't fit
	. . else  set x("val")=x("val")_raw,raw=""					; look for additional continuation node
	. else  for  do  quit:(""=raw!'cindex)						; look for concatenations and quotes
	. . set cp=$zfind(raw,"_"),qptr=$zfind(raw,""""),len=$zlength(raw)
	. . if qoff,cp+1=qptr,"$"'=$zextract(raw) do  quit				; a case of done
	. . . BREAK:debug  set x("val")=x("val")_$zextract(raw,1,cp-2),$zextract(raw,cp)=""
	. . if qptr+1=cp do  quit							; a case of done
	. . . BREAK:debug  set x("val")=x("val")_$zextract(raw,1,qptr-2),$zextract(raw,1,qptr)=""
	. . for  quit:'qptr!(cp&(cp<qptr))  do						; deal with a quote
	. . . set x("val")=x("val")_$zextract(raw,1,qptr-1),$zextract(raw,1,qptr)=""	; pick up the quote and what's before it
	. . . if (""=raw)&'cp BREAK:debug  set qptr=0  quit				; a case of done
	. . . set qoff='qoff,cp=$zfind(raw,"_"),len=$zlength(raw)			; next line does quotes in a row
	. . . for qptr=1:1 quit:""""'=$zextract(raw,qptr)  quit:qptr'<len  set:qoff x("val")=x("val")_"""" set qoff='qoff
	. . . if ($zl(raw)=qptr) BREAK:debug  set qptr=0,raw="" quit			; a case of done
	. . . if cp,"$"=$zextract(raw,1,qptr) do  quit					; now must ditch the  quote grabbed above
	. . . . set $zextract(x("val"),$zlength(x("val")))="",cp=1,qptr=$zfind(raw,"""")
	. . . if qptr+1=cp set $zextract(raw,1,qptr)="",cp=1,qptr=$zfind(raw,"""") quit	; switch to $[Z]C()
	. . . set $zextract(raw,1,qptr-1)=""
	. . . if ""=raw BREAK:debug  set:'qoff x("val")=x("val")_"""" quit		; a case of done
	. . . set cp=$zfind(raw,"_"),qptr=$zfind(raw,""""),len=$zlength(raw)
	. . if "$"=$zextract(raw) set cp=$zfind(raw,")") do				; $[Z]C() format for non-graphic characters
	. . . if cp do									; end of arguments in sight
	. . . . set len=$zlength(raw),value=$zextract(raw,1,$select(cp:$increment(cp)-2,1:len))
	. . . . set raw=$select(($increment(cp,(""""=$zextract(raw,cp)))<len):$zextract(raw,cp,len),1:"")
	. . . else  for  do  quit:cp!'$data(wed)					; a break in input due to node length
	. . . . set wed=$get(@x("x")@(x("index"),cindex)),cp=$zfind(wed,"_")
	. . . . if 'cp,""=wed,")"=$zextract(raw,$zlength(raw)) set cp=$zlength(raw)	; the end as a special case
	. . . . if (2**20)<($zlength(raw)+$select(cp:+cp-1,1:$zlength(wed)))!('cp&(""=wed)) do  quit
	. . . . . do sendmsg("m7",.x,x("key")) set (cindex,cp)=0,x("val")=""		; no available $[Z]C() terminator
	. . . . . set cindex=0,(raw,wed)="" kill wed
	. . . . if 'cp,$increment(cindex) set raw=raw_wed quit				; need another node
	. . . . set value=raw_$zextract(wed,1,cp-1)					; deal with stiched together $[Z]C()
	. . . . set:$increment(cindex) raw=$zextract(wed,cp,$zlength(wed)),len=$zlength(raw)	; next line alias indicator removal
	. . . . set:(" ;*"=$zextract(raw,len-2,len))&'$data(@x("x")@(x("index"),cindex+1)) $zextract(raw,len-2,len)=""
	. . . . kill wed
	. . . set value=$zwrite(value,1)						; convert any ZWRITE format to character
	. . else  do:$zlength(raw)							; not $[Z]C() format
	. . . set len=$zlength(raw),value=$zextract(raw,$select(""""=$zextract(raw):2,1:1),$select(qptr:qptr-2,1:len))
	. . . set raw=$select(qptr:$zextract(raw,qptr,len),1:"")
	. . if ((2**20)<($zlength(x("val"))+$zlength($get(value)))) do  quit
	. . . do sendmsg("m6",.x,x("key")) set (cindex,cp)=0,x("val")=""		; won't fit
	. . set x("val")=x("val")_value,value=""
	. set value=$get(@x("x")@(x("index"),cindex))
	. if ""'=value set len=$zlength(value) do
	. . do:(" ;*"=$zextract(value,len-2,len))&'$data(@x("x")@(x("index"),cindex+1))
	. . . set $zextract(value,len-2,len)="",len=len-2				; remove any alias indicator
	. . if ((2**20)<($zlength(raw)+len)) do  quit
	. . . do sendmsg("m6",.x,x("key")) set (cindex,cp)=0,x("val")=""		; won't fit
	. . set raw=raw_value
	. else  set cindex=0 quit							; no more continuation nodes
	set len=$zlength(x("val")),value=$zextract(x("val"),len-1,len)
	if """"""'=value,""""=$zextract(value,2) set $zextract(x("val"),len)=""		; check for & deal with one quote too many
	quit $select(('cindex&+$get(x("ret"),1)):"d",1:x("ret"))			; signal assign or skip

sendmsg(msg,x,parm)	; message thing - could use ZMESSAGE, SET $ECODE or other techniques setter if there's a need
	new i,io,m	; leading (nonlabel) piece indicates 0: all is lost or 1: just a variable (but could be sole
	set m=$text(@msg)
	if $increment(x("cnt")) set x("ret")=$zpiece(m,";",2)				; count skipped items and maintain "ret"
	set m=$zpiece(m,";",3,99)
	set:""=m m=msg_" is not a valid message for sendmsg^"_$text(+0)_" or the source module is unavailable"
	set i=$zfind(m,"~")
	set:i $zextract(m,i-1)=$zextract($get(parm),1,2**20-$zlength(m)-1)
	set io=$io
	use $principal
	write !,m,!
	use io
	quit
m0	;0;^%ZSHOWVTOLCL won't run if ""'=$ecode
m1	;0;~ is not a global reference
m2	;1;~ does not match base for ZSHOW "V" format
m3	;0;~ does not contain ZSHOW "V" data
m4	;1;Cannot restore %ZSHOWvbase
m5	;1;Truncated key starting with ~ possibly due to small database block size
m6	;1;Could not work ~ into a value within current processing limits
m7	;1;Failed to process $[Z]CHAR() representation for ~
m8	;1;~ items skipped due to errors
